/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.VpcCidrBlockState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VpcIpv6CidrBlockAssociation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, VpcIpv6CidrBlockAssociation> {
    private static final SdkField<String> ASSOCIATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AssociationId").getter(VpcIpv6CidrBlockAssociation.getter(VpcIpv6CidrBlockAssociation::associationId)).setter(VpcIpv6CidrBlockAssociation.setter(Builder::associationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociationId").unmarshallLocationName("associationId").build()}).build();
    private static final SdkField<String> IPV6_CIDR_BLOCK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Ipv6CidrBlock").getter(VpcIpv6CidrBlockAssociation.getter(VpcIpv6CidrBlockAssociation::ipv6CidrBlock)).setter(VpcIpv6CidrBlockAssociation.setter(Builder::ipv6CidrBlock)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv6CidrBlock").unmarshallLocationName("ipv6CidrBlock").build()}).build();
    private static final SdkField<VpcCidrBlockState> IPV6_CIDR_BLOCK_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Ipv6CidrBlockState").getter(VpcIpv6CidrBlockAssociation.getter(VpcIpv6CidrBlockAssociation::ipv6CidrBlockState)).setter(VpcIpv6CidrBlockAssociation.setter(Builder::ipv6CidrBlockState)).constructor(VpcCidrBlockState::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv6CidrBlockState").unmarshallLocationName("ipv6CidrBlockState").build()}).build();
    private static final SdkField<String> NETWORK_BORDER_GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NetworkBorderGroup").getter(VpcIpv6CidrBlockAssociation.getter(VpcIpv6CidrBlockAssociation::networkBorderGroup)).setter(VpcIpv6CidrBlockAssociation.setter(Builder::networkBorderGroup)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkBorderGroup").unmarshallLocationName("networkBorderGroup").build()}).build();
    private static final SdkField<String> IPV6_POOL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Ipv6Pool").getter(VpcIpv6CidrBlockAssociation.getter(VpcIpv6CidrBlockAssociation::ipv6Pool)).setter(VpcIpv6CidrBlockAssociation.setter(Builder::ipv6Pool)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv6Pool").unmarshallLocationName("ipv6Pool").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSOCIATION_ID_FIELD, IPV6_CIDR_BLOCK_FIELD, IPV6_CIDR_BLOCK_STATE_FIELD, NETWORK_BORDER_GROUP_FIELD, IPV6_POOL_FIELD));
    private static final long serialVersionUID = 1L;
    private final String associationId;
    private final String ipv6CidrBlock;
    private final VpcCidrBlockState ipv6CidrBlockState;
    private final String networkBorderGroup;
    private final String ipv6Pool;

    private VpcIpv6CidrBlockAssociation(BuilderImpl builder) {
        this.associationId = builder.associationId;
        this.ipv6CidrBlock = builder.ipv6CidrBlock;
        this.ipv6CidrBlockState = builder.ipv6CidrBlockState;
        this.networkBorderGroup = builder.networkBorderGroup;
        this.ipv6Pool = builder.ipv6Pool;
    }

    public String associationId() {
        return this.associationId;
    }

    public String ipv6CidrBlock() {
        return this.ipv6CidrBlock;
    }

    public VpcCidrBlockState ipv6CidrBlockState() {
        return this.ipv6CidrBlockState;
    }

    public String networkBorderGroup() {
        return this.networkBorderGroup;
    }

    public String ipv6Pool() {
        return this.ipv6Pool;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.associationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipv6CidrBlock());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipv6CidrBlockState());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkBorderGroup());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipv6Pool());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VpcIpv6CidrBlockAssociation)) {
            return false;
        }
        VpcIpv6CidrBlockAssociation other = (VpcIpv6CidrBlockAssociation)obj;
        return Objects.equals(this.associationId(), other.associationId()) && Objects.equals(this.ipv6CidrBlock(), other.ipv6CidrBlock()) && Objects.equals(this.ipv6CidrBlockState(), other.ipv6CidrBlockState()) && Objects.equals(this.networkBorderGroup(), other.networkBorderGroup()) && Objects.equals(this.ipv6Pool(), other.ipv6Pool());
    }

    public String toString() {
        return ToString.builder((String)"VpcIpv6CidrBlockAssociation").add("AssociationId", (Object)this.associationId()).add("Ipv6CidrBlock", (Object)this.ipv6CidrBlock()).add("Ipv6CidrBlockState", (Object)this.ipv6CidrBlockState()).add("NetworkBorderGroup", (Object)this.networkBorderGroup()).add("Ipv6Pool", (Object)this.ipv6Pool()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AssociationId": {
                return Optional.ofNullable(clazz.cast(this.associationId()));
            }
            case "Ipv6CidrBlock": {
                return Optional.ofNullable(clazz.cast(this.ipv6CidrBlock()));
            }
            case "Ipv6CidrBlockState": {
                return Optional.ofNullable(clazz.cast(this.ipv6CidrBlockState()));
            }
            case "NetworkBorderGroup": {
                return Optional.ofNullable(clazz.cast(this.networkBorderGroup()));
            }
            case "Ipv6Pool": {
                return Optional.ofNullable(clazz.cast(this.ipv6Pool()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VpcIpv6CidrBlockAssociation, T> g) {
        return obj -> g.apply((VpcIpv6CidrBlockAssociation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String associationId;
        private String ipv6CidrBlock;
        private VpcCidrBlockState ipv6CidrBlockState;
        private String networkBorderGroup;
        private String ipv6Pool;

        private BuilderImpl() {
        }

        private BuilderImpl(VpcIpv6CidrBlockAssociation model) {
            this.associationId(model.associationId);
            this.ipv6CidrBlock(model.ipv6CidrBlock);
            this.ipv6CidrBlockState(model.ipv6CidrBlockState);
            this.networkBorderGroup(model.networkBorderGroup);
            this.ipv6Pool(model.ipv6Pool);
        }

        public final String getAssociationId() {
            return this.associationId;
        }

        @Override
        public final Builder associationId(String associationId) {
            this.associationId = associationId;
            return this;
        }

        public final void setAssociationId(String associationId) {
            this.associationId = associationId;
        }

        public final String getIpv6CidrBlock() {
            return this.ipv6CidrBlock;
        }

        @Override
        public final Builder ipv6CidrBlock(String ipv6CidrBlock) {
            this.ipv6CidrBlock = ipv6CidrBlock;
            return this;
        }

        public final void setIpv6CidrBlock(String ipv6CidrBlock) {
            this.ipv6CidrBlock = ipv6CidrBlock;
        }

        public final VpcCidrBlockState.Builder getIpv6CidrBlockState() {
            return this.ipv6CidrBlockState != null ? this.ipv6CidrBlockState.toBuilder() : null;
        }

        @Override
        public final Builder ipv6CidrBlockState(VpcCidrBlockState ipv6CidrBlockState) {
            this.ipv6CidrBlockState = ipv6CidrBlockState;
            return this;
        }

        public final void setIpv6CidrBlockState(VpcCidrBlockState.BuilderImpl ipv6CidrBlockState) {
            this.ipv6CidrBlockState = ipv6CidrBlockState != null ? ipv6CidrBlockState.build() : null;
        }

        public final String getNetworkBorderGroup() {
            return this.networkBorderGroup;
        }

        @Override
        public final Builder networkBorderGroup(String networkBorderGroup) {
            this.networkBorderGroup = networkBorderGroup;
            return this;
        }

        public final void setNetworkBorderGroup(String networkBorderGroup) {
            this.networkBorderGroup = networkBorderGroup;
        }

        public final String getIpv6Pool() {
            return this.ipv6Pool;
        }

        @Override
        public final Builder ipv6Pool(String ipv6Pool) {
            this.ipv6Pool = ipv6Pool;
            return this;
        }

        public final void setIpv6Pool(String ipv6Pool) {
            this.ipv6Pool = ipv6Pool;
        }

        public VpcIpv6CidrBlockAssociation build() {
            return new VpcIpv6CidrBlockAssociation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, VpcIpv6CidrBlockAssociation> {
        public Builder associationId(String var1);

        public Builder ipv6CidrBlock(String var1);

        public Builder ipv6CidrBlockState(VpcCidrBlockState var1);

        default public Builder ipv6CidrBlockState(Consumer<VpcCidrBlockState.Builder> ipv6CidrBlockState) {
            return this.ipv6CidrBlockState((VpcCidrBlockState)((VpcCidrBlockState.Builder)VpcCidrBlockState.builder().applyMutation(ipv6CidrBlockState)).build());
        }

        public Builder networkBorderGroup(String var1);

        public Builder ipv6Pool(String var1);
    }
}

