/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.SpotFleetRequestConfigData;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RequestSpotFleetRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, RequestSpotFleetRequest> {
    private static final SdkField<SpotFleetRequestConfigData> SPOT_FLEET_REQUEST_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SpotFleetRequestConfig").getter(RequestSpotFleetRequest.getter(RequestSpotFleetRequest::spotFleetRequestConfig)).setter(RequestSpotFleetRequest.setter(Builder::spotFleetRequestConfig)).constructor(SpotFleetRequestConfigData::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpotFleetRequestConfig").unmarshallLocationName("spotFleetRequestConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SPOT_FLEET_REQUEST_CONFIG_FIELD));
    private final SpotFleetRequestConfigData spotFleetRequestConfig;

    private RequestSpotFleetRequest(BuilderImpl builder) {
        super(builder);
        this.spotFleetRequestConfig = builder.spotFleetRequestConfig;
    }

    public SpotFleetRequestConfigData spotFleetRequestConfig() {
        return this.spotFleetRequestConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.spotFleetRequestConfig());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RequestSpotFleetRequest)) {
            return false;
        }
        RequestSpotFleetRequest other = (RequestSpotFleetRequest)((Object)obj);
        return Objects.equals(this.spotFleetRequestConfig(), other.spotFleetRequestConfig());
    }

    public String toString() {
        return ToString.builder((String)"RequestSpotFleetRequest").add("SpotFleetRequestConfig", (Object)this.spotFleetRequestConfig()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SpotFleetRequestConfig": {
                return Optional.ofNullable(clazz.cast(this.spotFleetRequestConfig()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RequestSpotFleetRequest, T> g) {
        return obj -> g.apply((RequestSpotFleetRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private SpotFleetRequestConfigData spotFleetRequestConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(RequestSpotFleetRequest model) {
            super(model);
            this.spotFleetRequestConfig(model.spotFleetRequestConfig);
        }

        public final SpotFleetRequestConfigData.Builder getSpotFleetRequestConfig() {
            return this.spotFleetRequestConfig != null ? this.spotFleetRequestConfig.toBuilder() : null;
        }

        @Override
        public final Builder spotFleetRequestConfig(SpotFleetRequestConfigData spotFleetRequestConfig) {
            this.spotFleetRequestConfig = spotFleetRequestConfig;
            return this;
        }

        public final void setSpotFleetRequestConfig(SpotFleetRequestConfigData.BuilderImpl spotFleetRequestConfig) {
            this.spotFleetRequestConfig = spotFleetRequestConfig != null ? spotFleetRequestConfig.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RequestSpotFleetRequest build() {
            return new RequestSpotFleetRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RequestSpotFleetRequest> {
        public Builder spotFleetRequestConfig(SpotFleetRequestConfigData var1);

        default public Builder spotFleetRequestConfig(Consumer<SpotFleetRequestConfigData.Builder> spotFleetRequestConfig) {
            return this.spotFleetRequestConfig((SpotFleetRequestConfigData)((SpotFleetRequestConfigData.Builder)SpotFleetRequestConfigData.builder().applyMutation(spotFleetRequestConfig)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

