/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.EnableFastSnapshotRestoreErrorItem;
import software.amazon.awssdk.services.ec2.model.EnableFastSnapshotRestoreErrorSetCopier;
import software.amazon.awssdk.services.ec2.model.EnableFastSnapshotRestoreSuccessItem;
import software.amazon.awssdk.services.ec2.model.EnableFastSnapshotRestoreSuccessSetCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EnableFastSnapshotRestoresResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, EnableFastSnapshotRestoresResponse> {
    private static final SdkField<List<EnableFastSnapshotRestoreSuccessItem>> SUCCESSFUL_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Successful").getter(EnableFastSnapshotRestoresResponse.getter(EnableFastSnapshotRestoresResponse::successful)).setter(EnableFastSnapshotRestoresResponse.setter(Builder::successful)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Successful").unmarshallLocationName("successful").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EnableFastSnapshotRestoreSuccessItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<List<EnableFastSnapshotRestoreErrorItem>> UNSUCCESSFUL_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Unsuccessful").getter(EnableFastSnapshotRestoresResponse.getter(EnableFastSnapshotRestoresResponse::unsuccessful)).setter(EnableFastSnapshotRestoresResponse.setter(Builder::unsuccessful)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Unsuccessful").unmarshallLocationName("unsuccessful").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EnableFastSnapshotRestoreErrorItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUCCESSFUL_FIELD, UNSUCCESSFUL_FIELD));
    private final List<EnableFastSnapshotRestoreSuccessItem> successful;
    private final List<EnableFastSnapshotRestoreErrorItem> unsuccessful;

    private EnableFastSnapshotRestoresResponse(BuilderImpl builder) {
        super(builder);
        this.successful = builder.successful;
        this.unsuccessful = builder.unsuccessful;
    }

    public boolean hasSuccessful() {
        return this.successful != null && !(this.successful instanceof SdkAutoConstructList);
    }

    public List<EnableFastSnapshotRestoreSuccessItem> successful() {
        return this.successful;
    }

    public boolean hasUnsuccessful() {
        return this.unsuccessful != null && !(this.unsuccessful instanceof SdkAutoConstructList);
    }

    public List<EnableFastSnapshotRestoreErrorItem> unsuccessful() {
        return this.unsuccessful;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.successful());
        hashCode = 31 * hashCode + Objects.hashCode(this.unsuccessful());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnableFastSnapshotRestoresResponse)) {
            return false;
        }
        EnableFastSnapshotRestoresResponse other = (EnableFastSnapshotRestoresResponse)((Object)obj);
        return Objects.equals(this.successful(), other.successful()) && Objects.equals(this.unsuccessful(), other.unsuccessful());
    }

    public String toString() {
        return ToString.builder((String)"EnableFastSnapshotRestoresResponse").add("Successful", this.successful()).add("Unsuccessful", this.unsuccessful()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Successful": {
                return Optional.ofNullable(clazz.cast(this.successful()));
            }
            case "Unsuccessful": {
                return Optional.ofNullable(clazz.cast(this.unsuccessful()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EnableFastSnapshotRestoresResponse, T> g) {
        return obj -> g.apply((EnableFastSnapshotRestoresResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<EnableFastSnapshotRestoreSuccessItem> successful = DefaultSdkAutoConstructList.getInstance();
        private List<EnableFastSnapshotRestoreErrorItem> unsuccessful = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EnableFastSnapshotRestoresResponse model) {
            super(model);
            this.successful(model.successful);
            this.unsuccessful(model.unsuccessful);
        }

        public final Collection<EnableFastSnapshotRestoreSuccessItem.Builder> getSuccessful() {
            return this.successful != null ? (Collection)this.successful.stream().map(EnableFastSnapshotRestoreSuccessItem::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder successful(Collection<EnableFastSnapshotRestoreSuccessItem> successful) {
            this.successful = EnableFastSnapshotRestoreSuccessSetCopier.copy(successful);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder successful(EnableFastSnapshotRestoreSuccessItem ... successful) {
            this.successful(Arrays.asList(successful));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder successful(Consumer<EnableFastSnapshotRestoreSuccessItem.Builder> ... successful) {
            this.successful(Stream.of(successful).map(c -> (EnableFastSnapshotRestoreSuccessItem)((EnableFastSnapshotRestoreSuccessItem.Builder)EnableFastSnapshotRestoreSuccessItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSuccessful(Collection<EnableFastSnapshotRestoreSuccessItem.BuilderImpl> successful) {
            this.successful = EnableFastSnapshotRestoreSuccessSetCopier.copyFromBuilder(successful);
        }

        public final Collection<EnableFastSnapshotRestoreErrorItem.Builder> getUnsuccessful() {
            return this.unsuccessful != null ? (Collection)this.unsuccessful.stream().map(EnableFastSnapshotRestoreErrorItem::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder unsuccessful(Collection<EnableFastSnapshotRestoreErrorItem> unsuccessful) {
            this.unsuccessful = EnableFastSnapshotRestoreErrorSetCopier.copy(unsuccessful);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unsuccessful(EnableFastSnapshotRestoreErrorItem ... unsuccessful) {
            this.unsuccessful(Arrays.asList(unsuccessful));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unsuccessful(Consumer<EnableFastSnapshotRestoreErrorItem.Builder> ... unsuccessful) {
            this.unsuccessful(Stream.of(unsuccessful).map(c -> (EnableFastSnapshotRestoreErrorItem)((EnableFastSnapshotRestoreErrorItem.Builder)EnableFastSnapshotRestoreErrorItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setUnsuccessful(Collection<EnableFastSnapshotRestoreErrorItem.BuilderImpl> unsuccessful) {
            this.unsuccessful = EnableFastSnapshotRestoreErrorSetCopier.copyFromBuilder(unsuccessful);
        }

        @Override
        public EnableFastSnapshotRestoresResponse build() {
            return new EnableFastSnapshotRestoresResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, EnableFastSnapshotRestoresResponse> {
        public Builder successful(Collection<EnableFastSnapshotRestoreSuccessItem> var1);

        public Builder successful(EnableFastSnapshotRestoreSuccessItem ... var1);

        public Builder successful(Consumer<EnableFastSnapshotRestoreSuccessItem.Builder> ... var1);

        public Builder unsuccessful(Collection<EnableFastSnapshotRestoreErrorItem> var1);

        public Builder unsuccessful(EnableFastSnapshotRestoreErrorItem ... var1);

        public Builder unsuccessful(Consumer<EnableFastSnapshotRestoreErrorItem.Builder> ... var1);
    }
}

