/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.ConnectionNotification;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateVpcEndpointConnectionNotificationResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, CreateVpcEndpointConnectionNotificationResponse> {
    private static final SdkField<ConnectionNotification> CONNECTION_NOTIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ConnectionNotification").getter(CreateVpcEndpointConnectionNotificationResponse.getter(CreateVpcEndpointConnectionNotificationResponse::connectionNotification)).setter(CreateVpcEndpointConnectionNotificationResponse.setter(Builder::connectionNotification)).constructor(ConnectionNotification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionNotification").unmarshallLocationName("connectionNotification").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(CreateVpcEndpointConnectionNotificationResponse.getter(CreateVpcEndpointConnectionNotificationResponse::clientToken)).setter(CreateVpcEndpointConnectionNotificationResponse.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").unmarshallLocationName("clientToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTION_NOTIFICATION_FIELD, CLIENT_TOKEN_FIELD));
    private final ConnectionNotification connectionNotification;
    private final String clientToken;

    private CreateVpcEndpointConnectionNotificationResponse(BuilderImpl builder) {
        super(builder);
        this.connectionNotification = builder.connectionNotification;
        this.clientToken = builder.clientToken;
    }

    public ConnectionNotification connectionNotification() {
        return this.connectionNotification;
    }

    public String clientToken() {
        return this.clientToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionNotification());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateVpcEndpointConnectionNotificationResponse)) {
            return false;
        }
        CreateVpcEndpointConnectionNotificationResponse other = (CreateVpcEndpointConnectionNotificationResponse)((Object)obj);
        return Objects.equals(this.connectionNotification(), other.connectionNotification()) && Objects.equals(this.clientToken(), other.clientToken());
    }

    public String toString() {
        return ToString.builder((String)"CreateVpcEndpointConnectionNotificationResponse").add("ConnectionNotification", (Object)this.connectionNotification()).add("ClientToken", (Object)this.clientToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConnectionNotification": {
                return Optional.ofNullable(clazz.cast(this.connectionNotification()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateVpcEndpointConnectionNotificationResponse, T> g) {
        return obj -> g.apply((CreateVpcEndpointConnectionNotificationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private ConnectionNotification connectionNotification;
        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateVpcEndpointConnectionNotificationResponse model) {
            super(model);
            this.connectionNotification(model.connectionNotification);
            this.clientToken(model.clientToken);
        }

        public final ConnectionNotification.Builder getConnectionNotification() {
            return this.connectionNotification != null ? this.connectionNotification.toBuilder() : null;
        }

        @Override
        public final Builder connectionNotification(ConnectionNotification connectionNotification) {
            this.connectionNotification = connectionNotification;
            return this;
        }

        public final void setConnectionNotification(ConnectionNotification.BuilderImpl connectionNotification) {
            this.connectionNotification = connectionNotification != null ? connectionNotification.build() : null;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public CreateVpcEndpointConnectionNotificationResponse build() {
            return new CreateVpcEndpointConnectionNotificationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateVpcEndpointConnectionNotificationResponse> {
        public Builder connectionNotification(ConnectionNotification var1);

        default public Builder connectionNotification(Consumer<ConnectionNotification.Builder> connectionNotification) {
            return this.connectionNotification((ConnectionNotification)((ConnectionNotification.Builder)ConnectionNotification.builder().applyMutation(connectionNotification)).build());
        }

        public Builder clientToken(String var1);
    }
}

