/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateClientVpnRouteRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, CreateClientVpnRouteRequest> {
    private static final SdkField<String> CLIENT_VPN_ENDPOINT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientVpnEndpointId").getter(CreateClientVpnRouteRequest.getter(CreateClientVpnRouteRequest::clientVpnEndpointId)).setter(CreateClientVpnRouteRequest.setter(Builder::clientVpnEndpointId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientVpnEndpointId").unmarshallLocationName("ClientVpnEndpointId").build()}).build();
    private static final SdkField<String> DESTINATION_CIDR_BLOCK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DestinationCidrBlock").getter(CreateClientVpnRouteRequest.getter(CreateClientVpnRouteRequest::destinationCidrBlock)).setter(CreateClientVpnRouteRequest.setter(Builder::destinationCidrBlock)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationCidrBlock").unmarshallLocationName("DestinationCidrBlock").build()}).build();
    private static final SdkField<String> TARGET_VPC_SUBNET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TargetVpcSubnetId").getter(CreateClientVpnRouteRequest.getter(CreateClientVpnRouteRequest::targetVpcSubnetId)).setter(CreateClientVpnRouteRequest.setter(Builder::targetVpcSubnetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetVpcSubnetId").unmarshallLocationName("TargetVpcSubnetId").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(CreateClientVpnRouteRequest.getter(CreateClientVpnRouteRequest::description)).setter(CreateClientVpnRouteRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").unmarshallLocationName("Description").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(CreateClientVpnRouteRequest.getter(CreateClientVpnRouteRequest::clientToken)).setter(CreateClientVpnRouteRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").unmarshallLocationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_VPN_ENDPOINT_ID_FIELD, DESTINATION_CIDR_BLOCK_FIELD, TARGET_VPC_SUBNET_ID_FIELD, DESCRIPTION_FIELD, CLIENT_TOKEN_FIELD));
    private final String clientVpnEndpointId;
    private final String destinationCidrBlock;
    private final String targetVpcSubnetId;
    private final String description;
    private final String clientToken;

    private CreateClientVpnRouteRequest(BuilderImpl builder) {
        super(builder);
        this.clientVpnEndpointId = builder.clientVpnEndpointId;
        this.destinationCidrBlock = builder.destinationCidrBlock;
        this.targetVpcSubnetId = builder.targetVpcSubnetId;
        this.description = builder.description;
        this.clientToken = builder.clientToken;
    }

    public String clientVpnEndpointId() {
        return this.clientVpnEndpointId;
    }

    public String destinationCidrBlock() {
        return this.destinationCidrBlock;
    }

    public String targetVpcSubnetId() {
        return this.targetVpcSubnetId;
    }

    public String description() {
        return this.description;
    }

    public String clientToken() {
        return this.clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientVpnEndpointId());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationCidrBlock());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetVpcSubnetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateClientVpnRouteRequest)) {
            return false;
        }
        CreateClientVpnRouteRequest other = (CreateClientVpnRouteRequest)((Object)obj);
        return Objects.equals(this.clientVpnEndpointId(), other.clientVpnEndpointId()) && Objects.equals(this.destinationCidrBlock(), other.destinationCidrBlock()) && Objects.equals(this.targetVpcSubnetId(), other.targetVpcSubnetId()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.clientToken(), other.clientToken());
    }

    public String toString() {
        return ToString.builder((String)"CreateClientVpnRouteRequest").add("ClientVpnEndpointId", (Object)this.clientVpnEndpointId()).add("DestinationCidrBlock", (Object)this.destinationCidrBlock()).add("TargetVpcSubnetId", (Object)this.targetVpcSubnetId()).add("Description", (Object)this.description()).add("ClientToken", (Object)this.clientToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClientVpnEndpointId": {
                return Optional.ofNullable(clazz.cast(this.clientVpnEndpointId()));
            }
            case "DestinationCidrBlock": {
                return Optional.ofNullable(clazz.cast(this.destinationCidrBlock()));
            }
            case "TargetVpcSubnetId": {
                return Optional.ofNullable(clazz.cast(this.targetVpcSubnetId()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateClientVpnRouteRequest, T> g) {
        return obj -> g.apply((CreateClientVpnRouteRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private String clientVpnEndpointId;
        private String destinationCidrBlock;
        private String targetVpcSubnetId;
        private String description;
        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateClientVpnRouteRequest model) {
            super(model);
            this.clientVpnEndpointId(model.clientVpnEndpointId);
            this.destinationCidrBlock(model.destinationCidrBlock);
            this.targetVpcSubnetId(model.targetVpcSubnetId);
            this.description(model.description);
            this.clientToken(model.clientToken);
        }

        public final String getClientVpnEndpointId() {
            return this.clientVpnEndpointId;
        }

        @Override
        public final Builder clientVpnEndpointId(String clientVpnEndpointId) {
            this.clientVpnEndpointId = clientVpnEndpointId;
            return this;
        }

        public final void setClientVpnEndpointId(String clientVpnEndpointId) {
            this.clientVpnEndpointId = clientVpnEndpointId;
        }

        public final String getDestinationCidrBlock() {
            return this.destinationCidrBlock;
        }

        @Override
        public final Builder destinationCidrBlock(String destinationCidrBlock) {
            this.destinationCidrBlock = destinationCidrBlock;
            return this;
        }

        public final void setDestinationCidrBlock(String destinationCidrBlock) {
            this.destinationCidrBlock = destinationCidrBlock;
        }

        public final String getTargetVpcSubnetId() {
            return this.targetVpcSubnetId;
        }

        @Override
        public final Builder targetVpcSubnetId(String targetVpcSubnetId) {
            this.targetVpcSubnetId = targetVpcSubnetId;
            return this;
        }

        public final void setTargetVpcSubnetId(String targetVpcSubnetId) {
            this.targetVpcSubnetId = targetVpcSubnetId;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateClientVpnRouteRequest build() {
            return new CreateClientVpnRouteRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateClientVpnRouteRequest> {
        public Builder clientVpnEndpointId(String var1);

        public Builder destinationCidrBlock(String var1);

        public Builder targetVpcSubnetId(String var1);

        public Builder description(String var1);

        public Builder clientToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

