/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LocalGatewayVirtualInterface
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LocalGatewayVirtualInterface> {
    private static final SdkField<String> LOCAL_GATEWAY_VIRTUAL_INTERFACE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LocalGatewayVirtualInterfaceId").getter(LocalGatewayVirtualInterface.getter(LocalGatewayVirtualInterface::localGatewayVirtualInterfaceId)).setter(LocalGatewayVirtualInterface.setter(Builder::localGatewayVirtualInterfaceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalGatewayVirtualInterfaceId").unmarshallLocationName("localGatewayVirtualInterfaceId").build()}).build();
    private static final SdkField<String> LOCAL_GATEWAY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LocalGatewayId").getter(LocalGatewayVirtualInterface.getter(LocalGatewayVirtualInterface::localGatewayId)).setter(LocalGatewayVirtualInterface.setter(Builder::localGatewayId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalGatewayId").unmarshallLocationName("localGatewayId").build()}).build();
    private static final SdkField<Integer> VLAN_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Vlan").getter(LocalGatewayVirtualInterface.getter(LocalGatewayVirtualInterface::vlan)).setter(LocalGatewayVirtualInterface.setter(Builder::vlan)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Vlan").unmarshallLocationName("vlan").build()}).build();
    private static final SdkField<String> LOCAL_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LocalAddress").getter(LocalGatewayVirtualInterface.getter(LocalGatewayVirtualInterface::localAddress)).setter(LocalGatewayVirtualInterface.setter(Builder::localAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalAddress").unmarshallLocationName("localAddress").build()}).build();
    private static final SdkField<String> PEER_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PeerAddress").getter(LocalGatewayVirtualInterface.getter(LocalGatewayVirtualInterface::peerAddress)).setter(LocalGatewayVirtualInterface.setter(Builder::peerAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PeerAddress").unmarshallLocationName("peerAddress").build()}).build();
    private static final SdkField<Integer> LOCAL_BGP_ASN_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("LocalBgpAsn").getter(LocalGatewayVirtualInterface.getter(LocalGatewayVirtualInterface::localBgpAsn)).setter(LocalGatewayVirtualInterface.setter(Builder::localBgpAsn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalBgpAsn").unmarshallLocationName("localBgpAsn").build()}).build();
    private static final SdkField<Integer> PEER_BGP_ASN_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("PeerBgpAsn").getter(LocalGatewayVirtualInterface.getter(LocalGatewayVirtualInterface::peerBgpAsn)).setter(LocalGatewayVirtualInterface.setter(Builder::peerBgpAsn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PeerBgpAsn").unmarshallLocationName("peerBgpAsn").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(LocalGatewayVirtualInterface.getter(LocalGatewayVirtualInterface::tags)).setter(LocalGatewayVirtualInterface.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet").unmarshallLocationName("tagSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOCAL_GATEWAY_VIRTUAL_INTERFACE_ID_FIELD, LOCAL_GATEWAY_ID_FIELD, VLAN_FIELD, LOCAL_ADDRESS_FIELD, PEER_ADDRESS_FIELD, LOCAL_BGP_ASN_FIELD, PEER_BGP_ASN_FIELD, TAGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String localGatewayVirtualInterfaceId;
    private final String localGatewayId;
    private final Integer vlan;
    private final String localAddress;
    private final String peerAddress;
    private final Integer localBgpAsn;
    private final Integer peerBgpAsn;
    private final List<Tag> tags;

    private LocalGatewayVirtualInterface(BuilderImpl builder) {
        this.localGatewayVirtualInterfaceId = builder.localGatewayVirtualInterfaceId;
        this.localGatewayId = builder.localGatewayId;
        this.vlan = builder.vlan;
        this.localAddress = builder.localAddress;
        this.peerAddress = builder.peerAddress;
        this.localBgpAsn = builder.localBgpAsn;
        this.peerBgpAsn = builder.peerBgpAsn;
        this.tags = builder.tags;
    }

    public String localGatewayVirtualInterfaceId() {
        return this.localGatewayVirtualInterfaceId;
    }

    public String localGatewayId() {
        return this.localGatewayId;
    }

    public Integer vlan() {
        return this.vlan;
    }

    public String localAddress() {
        return this.localAddress;
    }

    public String peerAddress() {
        return this.peerAddress;
    }

    public Integer localBgpAsn() {
        return this.localBgpAsn;
    }

    public Integer peerBgpAsn() {
        return this.peerBgpAsn;
    }

    public boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.localGatewayVirtualInterfaceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.localGatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(this.vlan());
        hashCode = 31 * hashCode + Objects.hashCode(this.localAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.peerAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.localBgpAsn());
        hashCode = 31 * hashCode + Objects.hashCode(this.peerBgpAsn());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LocalGatewayVirtualInterface)) {
            return false;
        }
        LocalGatewayVirtualInterface other = (LocalGatewayVirtualInterface)obj;
        return Objects.equals(this.localGatewayVirtualInterfaceId(), other.localGatewayVirtualInterfaceId()) && Objects.equals(this.localGatewayId(), other.localGatewayId()) && Objects.equals(this.vlan(), other.vlan()) && Objects.equals(this.localAddress(), other.localAddress()) && Objects.equals(this.peerAddress(), other.peerAddress()) && Objects.equals(this.localBgpAsn(), other.localBgpAsn()) && Objects.equals(this.peerBgpAsn(), other.peerBgpAsn()) && Objects.equals(this.tags(), other.tags());
    }

    public String toString() {
        return ToString.builder((String)"LocalGatewayVirtualInterface").add("LocalGatewayVirtualInterfaceId", (Object)this.localGatewayVirtualInterfaceId()).add("LocalGatewayId", (Object)this.localGatewayId()).add("Vlan", (Object)this.vlan()).add("LocalAddress", (Object)this.localAddress()).add("PeerAddress", (Object)this.peerAddress()).add("LocalBgpAsn", (Object)this.localBgpAsn()).add("PeerBgpAsn", (Object)this.peerBgpAsn()).add("Tags", this.tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LocalGatewayVirtualInterfaceId": {
                return Optional.ofNullable(clazz.cast(this.localGatewayVirtualInterfaceId()));
            }
            case "LocalGatewayId": {
                return Optional.ofNullable(clazz.cast(this.localGatewayId()));
            }
            case "Vlan": {
                return Optional.ofNullable(clazz.cast(this.vlan()));
            }
            case "LocalAddress": {
                return Optional.ofNullable(clazz.cast(this.localAddress()));
            }
            case "PeerAddress": {
                return Optional.ofNullable(clazz.cast(this.peerAddress()));
            }
            case "LocalBgpAsn": {
                return Optional.ofNullable(clazz.cast(this.localBgpAsn()));
            }
            case "PeerBgpAsn": {
                return Optional.ofNullable(clazz.cast(this.peerBgpAsn()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LocalGatewayVirtualInterface, T> g) {
        return obj -> g.apply((LocalGatewayVirtualInterface)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String localGatewayVirtualInterfaceId;
        private String localGatewayId;
        private Integer vlan;
        private String localAddress;
        private String peerAddress;
        private Integer localBgpAsn;
        private Integer peerBgpAsn;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(LocalGatewayVirtualInterface model) {
            this.localGatewayVirtualInterfaceId(model.localGatewayVirtualInterfaceId);
            this.localGatewayId(model.localGatewayId);
            this.vlan(model.vlan);
            this.localAddress(model.localAddress);
            this.peerAddress(model.peerAddress);
            this.localBgpAsn(model.localBgpAsn);
            this.peerBgpAsn(model.peerBgpAsn);
            this.tags(model.tags);
        }

        public final String getLocalGatewayVirtualInterfaceId() {
            return this.localGatewayVirtualInterfaceId;
        }

        @Override
        public final Builder localGatewayVirtualInterfaceId(String localGatewayVirtualInterfaceId) {
            this.localGatewayVirtualInterfaceId = localGatewayVirtualInterfaceId;
            return this;
        }

        public final void setLocalGatewayVirtualInterfaceId(String localGatewayVirtualInterfaceId) {
            this.localGatewayVirtualInterfaceId = localGatewayVirtualInterfaceId;
        }

        public final String getLocalGatewayId() {
            return this.localGatewayId;
        }

        @Override
        public final Builder localGatewayId(String localGatewayId) {
            this.localGatewayId = localGatewayId;
            return this;
        }

        public final void setLocalGatewayId(String localGatewayId) {
            this.localGatewayId = localGatewayId;
        }

        public final Integer getVlan() {
            return this.vlan;
        }

        @Override
        public final Builder vlan(Integer vlan) {
            this.vlan = vlan;
            return this;
        }

        public final void setVlan(Integer vlan) {
            this.vlan = vlan;
        }

        public final String getLocalAddress() {
            return this.localAddress;
        }

        @Override
        public final Builder localAddress(String localAddress) {
            this.localAddress = localAddress;
            return this;
        }

        public final void setLocalAddress(String localAddress) {
            this.localAddress = localAddress;
        }

        public final String getPeerAddress() {
            return this.peerAddress;
        }

        @Override
        public final Builder peerAddress(String peerAddress) {
            this.peerAddress = peerAddress;
            return this;
        }

        public final void setPeerAddress(String peerAddress) {
            this.peerAddress = peerAddress;
        }

        public final Integer getLocalBgpAsn() {
            return this.localBgpAsn;
        }

        @Override
        public final Builder localBgpAsn(Integer localBgpAsn) {
            this.localBgpAsn = localBgpAsn;
            return this;
        }

        public final void setLocalBgpAsn(Integer localBgpAsn) {
            this.localBgpAsn = localBgpAsn;
        }

        public final Integer getPeerBgpAsn() {
            return this.peerBgpAsn;
        }

        @Override
        public final Builder peerBgpAsn(Integer peerBgpAsn) {
            this.peerBgpAsn = peerBgpAsn;
            return this;
        }

        public final void setPeerBgpAsn(Integer peerBgpAsn) {
            this.peerBgpAsn = peerBgpAsn;
        }

        public final Collection<Tag.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public LocalGatewayVirtualInterface build() {
            return new LocalGatewayVirtualInterface(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LocalGatewayVirtualInterface> {
        public Builder localGatewayVirtualInterfaceId(String var1);

        public Builder localGatewayId(String var1);

        public Builder vlan(Integer var1);

        public Builder localAddress(String var1);

        public Builder peerAddress(String var1);

        public Builder localBgpAsn(Integer var1);

        public Builder peerBgpAsn(Integer var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);
    }
}

