/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum FleetStateCode {
    SUBMITTED("submitted"),
    ACTIVE("active"),
    DELETED("deleted"),
    FAILED("failed"),
    DELETED_RUNNING("deleted_running"),
    DELETED_TERMINATING("deleted_terminating"),
    MODIFYING("modifying"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private FleetStateCode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static FleetStateCode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(FleetStateCode.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<FleetStateCode> knownValues() {
        return Stream.of(FleetStateCode.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

