/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.TransitGatewayAttachmentResourceType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TransitGatewayRouteAttachment
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TransitGatewayRouteAttachment> {
    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(TransitGatewayRouteAttachment.getter(TransitGatewayRouteAttachment::resourceId)).setter(TransitGatewayRouteAttachment.setter(Builder::resourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceId").unmarshallLocationName("resourceId").build()}).build();
    private static final SdkField<String> TRANSIT_GATEWAY_ATTACHMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(TransitGatewayRouteAttachment.getter(TransitGatewayRouteAttachment::transitGatewayAttachmentId)).setter(TransitGatewayRouteAttachment.setter(Builder::transitGatewayAttachmentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitGatewayAttachmentId").unmarshallLocationName("transitGatewayAttachmentId").build()}).build();
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(TransitGatewayRouteAttachment.getter(TransitGatewayRouteAttachment::resourceTypeAsString)).setter(TransitGatewayRouteAttachment.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").unmarshallLocationName("resourceType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ID_FIELD, TRANSIT_GATEWAY_ATTACHMENT_ID_FIELD, RESOURCE_TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String resourceId;
    private final String transitGatewayAttachmentId;
    private final String resourceType;

    private TransitGatewayRouteAttachment(BuilderImpl builder) {
        this.resourceId = builder.resourceId;
        this.transitGatewayAttachmentId = builder.transitGatewayAttachmentId;
        this.resourceType = builder.resourceType;
    }

    public String resourceId() {
        return this.resourceId;
    }

    public String transitGatewayAttachmentId() {
        return this.transitGatewayAttachmentId;
    }

    public TransitGatewayAttachmentResourceType resourceType() {
        return TransitGatewayAttachmentResourceType.fromValue(this.resourceType);
    }

    public String resourceTypeAsString() {
        return this.resourceType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.transitGatewayAttachmentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceTypeAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TransitGatewayRouteAttachment)) {
            return false;
        }
        TransitGatewayRouteAttachment other = (TransitGatewayRouteAttachment)obj;
        return Objects.equals(this.resourceId(), other.resourceId()) && Objects.equals(this.transitGatewayAttachmentId(), other.transitGatewayAttachmentId()) && Objects.equals(this.resourceTypeAsString(), other.resourceTypeAsString());
    }

    public String toString() {
        return ToString.builder((String)"TransitGatewayRouteAttachment").add("ResourceId", (Object)this.resourceId()).add("TransitGatewayAttachmentId", (Object)this.transitGatewayAttachmentId()).add("ResourceType", (Object)this.resourceTypeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceId": {
                return Optional.ofNullable(clazz.cast(this.resourceId()));
            }
            case "TransitGatewayAttachmentId": {
                return Optional.ofNullable(clazz.cast(this.transitGatewayAttachmentId()));
            }
            case "ResourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TransitGatewayRouteAttachment, T> g) {
        return obj -> g.apply((TransitGatewayRouteAttachment)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String resourceId;
        private String transitGatewayAttachmentId;
        private String resourceType;

        private BuilderImpl() {
        }

        private BuilderImpl(TransitGatewayRouteAttachment model) {
            this.resourceId(model.resourceId);
            this.transitGatewayAttachmentId(model.transitGatewayAttachmentId);
            this.resourceType(model.resourceType);
        }

        public final String getResourceId() {
            return this.resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        public final String getTransitGatewayAttachmentId() {
            return this.transitGatewayAttachmentId;
        }

        @Override
        public final Builder transitGatewayAttachmentId(String transitGatewayAttachmentId) {
            this.transitGatewayAttachmentId = transitGatewayAttachmentId;
            return this;
        }

        public final void setTransitGatewayAttachmentId(String transitGatewayAttachmentId) {
            this.transitGatewayAttachmentId = transitGatewayAttachmentId;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(TransitGatewayAttachmentResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public TransitGatewayRouteAttachment build() {
            return new TransitGatewayRouteAttachment(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TransitGatewayRouteAttachment> {
        public Builder resourceId(String var1);

        public Builder transitGatewayAttachmentId(String var1);

        public Builder resourceType(String var1);

        public Builder resourceType(TransitGatewayAttachmentResourceType var1);
    }
}

