/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.IpPermission;
import software.amazon.awssdk.services.ec2.model.IpPermissionListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RevokeSecurityGroupEgressRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, RevokeSecurityGroupEgressRequest> {
    private static final SdkField<String> GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RevokeSecurityGroupEgressRequest.getter(RevokeSecurityGroupEgressRequest::groupId)).setter(RevokeSecurityGroupEgressRequest.setter(Builder::groupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupId").unmarshallLocationName("groupId").build()}).build();
    private static final SdkField<List<IpPermission>> IP_PERMISSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(RevokeSecurityGroupEgressRequest.getter(RevokeSecurityGroupEgressRequest::ipPermissions)).setter(RevokeSecurityGroupEgressRequest.setter(Builder::ipPermissions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpPermissions").unmarshallLocationName("ipPermissions").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(IpPermission::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> CIDR_IP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RevokeSecurityGroupEgressRequest.getter(RevokeSecurityGroupEgressRequest::cidrIp)).setter(RevokeSecurityGroupEgressRequest.setter(Builder::cidrIp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CidrIp").unmarshallLocationName("cidrIp").build()}).build();
    private static final SdkField<Integer> FROM_PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(RevokeSecurityGroupEgressRequest.getter(RevokeSecurityGroupEgressRequest::fromPort)).setter(RevokeSecurityGroupEgressRequest.setter(Builder::fromPort)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FromPort").unmarshallLocationName("fromPort").build()}).build();
    private static final SdkField<String> IP_PROTOCOL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RevokeSecurityGroupEgressRequest.getter(RevokeSecurityGroupEgressRequest::ipProtocol)).setter(RevokeSecurityGroupEgressRequest.setter(Builder::ipProtocol)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpProtocol").unmarshallLocationName("ipProtocol").build()}).build();
    private static final SdkField<Integer> TO_PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(RevokeSecurityGroupEgressRequest.getter(RevokeSecurityGroupEgressRequest::toPort)).setter(RevokeSecurityGroupEgressRequest.setter(Builder::toPort)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ToPort").unmarshallLocationName("toPort").build()}).build();
    private static final SdkField<String> SOURCE_SECURITY_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RevokeSecurityGroupEgressRequest.getter(RevokeSecurityGroupEgressRequest::sourceSecurityGroupName)).setter(RevokeSecurityGroupEgressRequest.setter(Builder::sourceSecurityGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceSecurityGroupName").unmarshallLocationName("sourceSecurityGroupName").build()}).build();
    private static final SdkField<String> SOURCE_SECURITY_GROUP_OWNER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RevokeSecurityGroupEgressRequest.getter(RevokeSecurityGroupEgressRequest::sourceSecurityGroupOwnerId)).setter(RevokeSecurityGroupEgressRequest.setter(Builder::sourceSecurityGroupOwnerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceSecurityGroupOwnerId").unmarshallLocationName("sourceSecurityGroupOwnerId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUP_ID_FIELD, IP_PERMISSIONS_FIELD, CIDR_IP_FIELD, FROM_PORT_FIELD, IP_PROTOCOL_FIELD, TO_PORT_FIELD, SOURCE_SECURITY_GROUP_NAME_FIELD, SOURCE_SECURITY_GROUP_OWNER_ID_FIELD));
    private final String groupId;
    private final List<IpPermission> ipPermissions;
    private final String cidrIp;
    private final Integer fromPort;
    private final String ipProtocol;
    private final Integer toPort;
    private final String sourceSecurityGroupName;
    private final String sourceSecurityGroupOwnerId;

    private RevokeSecurityGroupEgressRequest(BuilderImpl builder) {
        super(builder);
        this.groupId = builder.groupId;
        this.ipPermissions = builder.ipPermissions;
        this.cidrIp = builder.cidrIp;
        this.fromPort = builder.fromPort;
        this.ipProtocol = builder.ipProtocol;
        this.toPort = builder.toPort;
        this.sourceSecurityGroupName = builder.sourceSecurityGroupName;
        this.sourceSecurityGroupOwnerId = builder.sourceSecurityGroupOwnerId;
    }

    public String groupId() {
        return this.groupId;
    }

    public boolean hasIpPermissions() {
        return this.ipPermissions != null && !(this.ipPermissions instanceof SdkAutoConstructList);
    }

    public List<IpPermission> ipPermissions() {
        return this.ipPermissions;
    }

    public String cidrIp() {
        return this.cidrIp;
    }

    public Integer fromPort() {
        return this.fromPort;
    }

    public String ipProtocol() {
        return this.ipProtocol;
    }

    public Integer toPort() {
        return this.toPort;
    }

    public String sourceSecurityGroupName() {
        return this.sourceSecurityGroupName;
    }

    public String sourceSecurityGroupOwnerId() {
        return this.sourceSecurityGroupOwnerId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.groupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipPermissions());
        hashCode = 31 * hashCode + Objects.hashCode(this.cidrIp());
        hashCode = 31 * hashCode + Objects.hashCode(this.fromPort());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipProtocol());
        hashCode = 31 * hashCode + Objects.hashCode(this.toPort());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceSecurityGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceSecurityGroupOwnerId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RevokeSecurityGroupEgressRequest)) {
            return false;
        }
        RevokeSecurityGroupEgressRequest other = (RevokeSecurityGroupEgressRequest)((Object)obj);
        return Objects.equals(this.groupId(), other.groupId()) && Objects.equals(this.ipPermissions(), other.ipPermissions()) && Objects.equals(this.cidrIp(), other.cidrIp()) && Objects.equals(this.fromPort(), other.fromPort()) && Objects.equals(this.ipProtocol(), other.ipProtocol()) && Objects.equals(this.toPort(), other.toPort()) && Objects.equals(this.sourceSecurityGroupName(), other.sourceSecurityGroupName()) && Objects.equals(this.sourceSecurityGroupOwnerId(), other.sourceSecurityGroupOwnerId());
    }

    public String toString() {
        return ToString.builder((String)"RevokeSecurityGroupEgressRequest").add("GroupId", (Object)this.groupId()).add("IpPermissions", this.ipPermissions()).add("CidrIp", (Object)this.cidrIp()).add("FromPort", (Object)this.fromPort()).add("IpProtocol", (Object)this.ipProtocol()).add("ToPort", (Object)this.toPort()).add("SourceSecurityGroupName", (Object)this.sourceSecurityGroupName()).add("SourceSecurityGroupOwnerId", (Object)this.sourceSecurityGroupOwnerId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GroupId": {
                return Optional.ofNullable(clazz.cast(this.groupId()));
            }
            case "IpPermissions": {
                return Optional.ofNullable(clazz.cast(this.ipPermissions()));
            }
            case "CidrIp": {
                return Optional.ofNullable(clazz.cast(this.cidrIp()));
            }
            case "FromPort": {
                return Optional.ofNullable(clazz.cast(this.fromPort()));
            }
            case "IpProtocol": {
                return Optional.ofNullable(clazz.cast(this.ipProtocol()));
            }
            case "ToPort": {
                return Optional.ofNullable(clazz.cast(this.toPort()));
            }
            case "SourceSecurityGroupName": {
                return Optional.ofNullable(clazz.cast(this.sourceSecurityGroupName()));
            }
            case "SourceSecurityGroupOwnerId": {
                return Optional.ofNullable(clazz.cast(this.sourceSecurityGroupOwnerId()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RevokeSecurityGroupEgressRequest, T> g) {
        return obj -> g.apply((RevokeSecurityGroupEgressRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private String groupId;
        private List<IpPermission> ipPermissions = DefaultSdkAutoConstructList.getInstance();
        private String cidrIp;
        private Integer fromPort;
        private String ipProtocol;
        private Integer toPort;
        private String sourceSecurityGroupName;
        private String sourceSecurityGroupOwnerId;

        private BuilderImpl() {
        }

        private BuilderImpl(RevokeSecurityGroupEgressRequest model) {
            super(model);
            this.groupId(model.groupId);
            this.ipPermissions(model.ipPermissions);
            this.cidrIp(model.cidrIp);
            this.fromPort(model.fromPort);
            this.ipProtocol(model.ipProtocol);
            this.toPort(model.toPort);
            this.sourceSecurityGroupName(model.sourceSecurityGroupName);
            this.sourceSecurityGroupOwnerId(model.sourceSecurityGroupOwnerId);
        }

        public final String getGroupId() {
            return this.groupId;
        }

        @Override
        public final Builder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public final void setGroupId(String groupId) {
            this.groupId = groupId;
        }

        public final Collection<IpPermission.Builder> getIpPermissions() {
            return this.ipPermissions != null ? (Collection)this.ipPermissions.stream().map(IpPermission::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder ipPermissions(Collection<IpPermission> ipPermissions) {
            this.ipPermissions = IpPermissionListCopier.copy(ipPermissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipPermissions(IpPermission ... ipPermissions) {
            this.ipPermissions(Arrays.asList(ipPermissions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipPermissions(Consumer<IpPermission.Builder> ... ipPermissions) {
            this.ipPermissions(Stream.of(ipPermissions).map(c -> (IpPermission)((IpPermission.Builder)IpPermission.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setIpPermissions(Collection<IpPermission.BuilderImpl> ipPermissions) {
            this.ipPermissions = IpPermissionListCopier.copyFromBuilder(ipPermissions);
        }

        public final String getCidrIp() {
            return this.cidrIp;
        }

        @Override
        public final Builder cidrIp(String cidrIp) {
            this.cidrIp = cidrIp;
            return this;
        }

        public final void setCidrIp(String cidrIp) {
            this.cidrIp = cidrIp;
        }

        public final Integer getFromPort() {
            return this.fromPort;
        }

        @Override
        public final Builder fromPort(Integer fromPort) {
            this.fromPort = fromPort;
            return this;
        }

        public final void setFromPort(Integer fromPort) {
            this.fromPort = fromPort;
        }

        public final String getIpProtocol() {
            return this.ipProtocol;
        }

        @Override
        public final Builder ipProtocol(String ipProtocol) {
            this.ipProtocol = ipProtocol;
            return this;
        }

        public final void setIpProtocol(String ipProtocol) {
            this.ipProtocol = ipProtocol;
        }

        public final Integer getToPort() {
            return this.toPort;
        }

        @Override
        public final Builder toPort(Integer toPort) {
            this.toPort = toPort;
            return this;
        }

        public final void setToPort(Integer toPort) {
            this.toPort = toPort;
        }

        public final String getSourceSecurityGroupName() {
            return this.sourceSecurityGroupName;
        }

        @Override
        public final Builder sourceSecurityGroupName(String sourceSecurityGroupName) {
            this.sourceSecurityGroupName = sourceSecurityGroupName;
            return this;
        }

        public final void setSourceSecurityGroupName(String sourceSecurityGroupName) {
            this.sourceSecurityGroupName = sourceSecurityGroupName;
        }

        public final String getSourceSecurityGroupOwnerId() {
            return this.sourceSecurityGroupOwnerId;
        }

        @Override
        public final Builder sourceSecurityGroupOwnerId(String sourceSecurityGroupOwnerId) {
            this.sourceSecurityGroupOwnerId = sourceSecurityGroupOwnerId;
            return this;
        }

        public final void setSourceSecurityGroupOwnerId(String sourceSecurityGroupOwnerId) {
            this.sourceSecurityGroupOwnerId = sourceSecurityGroupOwnerId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RevokeSecurityGroupEgressRequest build() {
            return new RevokeSecurityGroupEgressRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RevokeSecurityGroupEgressRequest> {
        public Builder groupId(String var1);

        public Builder ipPermissions(Collection<IpPermission> var1);

        public Builder ipPermissions(IpPermission ... var1);

        public Builder ipPermissions(Consumer<IpPermission.Builder> ... var1);

        public Builder cidrIp(String var1);

        public Builder fromPort(Integer var1);

        public Builder ipProtocol(String var1);

        public Builder toPort(Integer var1);

        public Builder sourceSecurityGroupName(String var1);

        public Builder sourceSecurityGroupOwnerId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

