/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.GroupIdentifier;
import software.amazon.awssdk.services.ec2.model.GroupIdentifierListCopier;
import software.amazon.awssdk.services.ec2.model.InstanceIpv6Address;
import software.amazon.awssdk.services.ec2.model.InstanceIpv6AddressListCopier;
import software.amazon.awssdk.services.ec2.model.InstanceNetworkInterfaceAssociation;
import software.amazon.awssdk.services.ec2.model.InstanceNetworkInterfaceAttachment;
import software.amazon.awssdk.services.ec2.model.InstancePrivateIpAddress;
import software.amazon.awssdk.services.ec2.model.InstancePrivateIpAddressListCopier;
import software.amazon.awssdk.services.ec2.model.NetworkInterfaceStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InstanceNetworkInterface
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InstanceNetworkInterface> {
    private static final SdkField<InstanceNetworkInterfaceAssociation> ASSOCIATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(InstanceNetworkInterface.getter(InstanceNetworkInterface::association)).setter(InstanceNetworkInterface.setter(Builder::association)).constructor(InstanceNetworkInterfaceAssociation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Association").unmarshallLocationName("association").build()}).build();
    private static final SdkField<InstanceNetworkInterfaceAttachment> ATTACHMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(InstanceNetworkInterface.getter(InstanceNetworkInterface::attachment)).setter(InstanceNetworkInterface.setter(Builder::attachment)).constructor(InstanceNetworkInterfaceAttachment::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attachment").unmarshallLocationName("attachment").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(InstanceNetworkInterface.getter(InstanceNetworkInterface::description)).setter(InstanceNetworkInterface.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").unmarshallLocationName("description").build()}).build();
    private static final SdkField<List<GroupIdentifier>> GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(InstanceNetworkInterface.getter(InstanceNetworkInterface::groups)).setter(InstanceNetworkInterface.setter(Builder::groups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupSet").unmarshallLocationName("groupSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(GroupIdentifier::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<List<InstanceIpv6Address>> IPV6_ADDRESSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(InstanceNetworkInterface.getter(InstanceNetworkInterface::ipv6Addresses)).setter(InstanceNetworkInterface.setter(Builder::ipv6Addresses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv6AddressesSet").unmarshallLocationName("ipv6AddressesSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InstanceIpv6Address::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> MAC_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(InstanceNetworkInterface.getter(InstanceNetworkInterface::macAddress)).setter(InstanceNetworkInterface.setter(Builder::macAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MacAddress").unmarshallLocationName("macAddress").build()}).build();
    private static final SdkField<String> NETWORK_INTERFACE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(InstanceNetworkInterface.getter(InstanceNetworkInterface::networkInterfaceId)).setter(InstanceNetworkInterface.setter(Builder::networkInterfaceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInterfaceId").unmarshallLocationName("networkInterfaceId").build()}).build();
    private static final SdkField<String> OWNER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(InstanceNetworkInterface.getter(InstanceNetworkInterface::ownerId)).setter(InstanceNetworkInterface.setter(Builder::ownerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerId").unmarshallLocationName("ownerId").build()}).build();
    private static final SdkField<String> PRIVATE_DNS_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(InstanceNetworkInterface.getter(InstanceNetworkInterface::privateDnsName)).setter(InstanceNetworkInterface.setter(Builder::privateDnsName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateDnsName").unmarshallLocationName("privateDnsName").build()}).build();
    private static final SdkField<String> PRIVATE_IP_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(InstanceNetworkInterface.getter(InstanceNetworkInterface::privateIpAddress)).setter(InstanceNetworkInterface.setter(Builder::privateIpAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateIpAddress").unmarshallLocationName("privateIpAddress").build()}).build();
    private static final SdkField<List<InstancePrivateIpAddress>> PRIVATE_IP_ADDRESSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(InstanceNetworkInterface.getter(InstanceNetworkInterface::privateIpAddresses)).setter(InstanceNetworkInterface.setter(Builder::privateIpAddresses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateIpAddressesSet").unmarshallLocationName("privateIpAddressesSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InstancePrivateIpAddress::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<Boolean> SOURCE_DEST_CHECK_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(InstanceNetworkInterface.getter(InstanceNetworkInterface::sourceDestCheck)).setter(InstanceNetworkInterface.setter(Builder::sourceDestCheck)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceDestCheck").unmarshallLocationName("sourceDestCheck").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(InstanceNetworkInterface.getter(InstanceNetworkInterface::statusAsString)).setter(InstanceNetworkInterface.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").unmarshallLocationName("status").build()}).build();
    private static final SdkField<String> SUBNET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(InstanceNetworkInterface.getter(InstanceNetworkInterface::subnetId)).setter(InstanceNetworkInterface.setter(Builder::subnetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetId").unmarshallLocationName("subnetId").build()}).build();
    private static final SdkField<String> VPC_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(InstanceNetworkInterface.getter(InstanceNetworkInterface::vpcId)).setter(InstanceNetworkInterface.setter(Builder::vpcId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId").unmarshallLocationName("vpcId").build()}).build();
    private static final SdkField<String> INTERFACE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(InstanceNetworkInterface.getter(InstanceNetworkInterface::interfaceType)).setter(InstanceNetworkInterface.setter(Builder::interfaceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InterfaceType").unmarshallLocationName("interfaceType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSOCIATION_FIELD, ATTACHMENT_FIELD, DESCRIPTION_FIELD, GROUPS_FIELD, IPV6_ADDRESSES_FIELD, MAC_ADDRESS_FIELD, NETWORK_INTERFACE_ID_FIELD, OWNER_ID_FIELD, PRIVATE_DNS_NAME_FIELD, PRIVATE_IP_ADDRESS_FIELD, PRIVATE_IP_ADDRESSES_FIELD, SOURCE_DEST_CHECK_FIELD, STATUS_FIELD, SUBNET_ID_FIELD, VPC_ID_FIELD, INTERFACE_TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final InstanceNetworkInterfaceAssociation association;
    private final InstanceNetworkInterfaceAttachment attachment;
    private final String description;
    private final List<GroupIdentifier> groups;
    private final List<InstanceIpv6Address> ipv6Addresses;
    private final String macAddress;
    private final String networkInterfaceId;
    private final String ownerId;
    private final String privateDnsName;
    private final String privateIpAddress;
    private final List<InstancePrivateIpAddress> privateIpAddresses;
    private final Boolean sourceDestCheck;
    private final String status;
    private final String subnetId;
    private final String vpcId;
    private final String interfaceType;

    private InstanceNetworkInterface(BuilderImpl builder) {
        this.association = builder.association;
        this.attachment = builder.attachment;
        this.description = builder.description;
        this.groups = builder.groups;
        this.ipv6Addresses = builder.ipv6Addresses;
        this.macAddress = builder.macAddress;
        this.networkInterfaceId = builder.networkInterfaceId;
        this.ownerId = builder.ownerId;
        this.privateDnsName = builder.privateDnsName;
        this.privateIpAddress = builder.privateIpAddress;
        this.privateIpAddresses = builder.privateIpAddresses;
        this.sourceDestCheck = builder.sourceDestCheck;
        this.status = builder.status;
        this.subnetId = builder.subnetId;
        this.vpcId = builder.vpcId;
        this.interfaceType = builder.interfaceType;
    }

    public InstanceNetworkInterfaceAssociation association() {
        return this.association;
    }

    public InstanceNetworkInterfaceAttachment attachment() {
        return this.attachment;
    }

    public String description() {
        return this.description;
    }

    public boolean hasGroups() {
        return this.groups != null && !(this.groups instanceof SdkAutoConstructList);
    }

    public List<GroupIdentifier> groups() {
        return this.groups;
    }

    public boolean hasIpv6Addresses() {
        return this.ipv6Addresses != null && !(this.ipv6Addresses instanceof SdkAutoConstructList);
    }

    public List<InstanceIpv6Address> ipv6Addresses() {
        return this.ipv6Addresses;
    }

    public String macAddress() {
        return this.macAddress;
    }

    public String networkInterfaceId() {
        return this.networkInterfaceId;
    }

    public String ownerId() {
        return this.ownerId;
    }

    public String privateDnsName() {
        return this.privateDnsName;
    }

    public String privateIpAddress() {
        return this.privateIpAddress;
    }

    public boolean hasPrivateIpAddresses() {
        return this.privateIpAddresses != null && !(this.privateIpAddresses instanceof SdkAutoConstructList);
    }

    public List<InstancePrivateIpAddress> privateIpAddresses() {
        return this.privateIpAddresses;
    }

    public Boolean sourceDestCheck() {
        return this.sourceDestCheck;
    }

    public NetworkInterfaceStatus status() {
        return NetworkInterfaceStatus.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public String subnetId() {
        return this.subnetId;
    }

    public String vpcId() {
        return this.vpcId;
    }

    public String interfaceType() {
        return this.interfaceType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.association());
        hashCode = 31 * hashCode + Objects.hashCode(this.attachment());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.groups());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipv6Addresses());
        hashCode = 31 * hashCode + Objects.hashCode(this.macAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkInterfaceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.privateDnsName());
        hashCode = 31 * hashCode + Objects.hashCode(this.privateIpAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.privateIpAddresses());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceDestCheck());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.subnetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(this.interfaceType());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceNetworkInterface)) {
            return false;
        }
        InstanceNetworkInterface other = (InstanceNetworkInterface)obj;
        return Objects.equals(this.association(), other.association()) && Objects.equals(this.attachment(), other.attachment()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.groups(), other.groups()) && Objects.equals(this.ipv6Addresses(), other.ipv6Addresses()) && Objects.equals(this.macAddress(), other.macAddress()) && Objects.equals(this.networkInterfaceId(), other.networkInterfaceId()) && Objects.equals(this.ownerId(), other.ownerId()) && Objects.equals(this.privateDnsName(), other.privateDnsName()) && Objects.equals(this.privateIpAddress(), other.privateIpAddress()) && Objects.equals(this.privateIpAddresses(), other.privateIpAddresses()) && Objects.equals(this.sourceDestCheck(), other.sourceDestCheck()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.subnetId(), other.subnetId()) && Objects.equals(this.vpcId(), other.vpcId()) && Objects.equals(this.interfaceType(), other.interfaceType());
    }

    public String toString() {
        return ToString.builder((String)"InstanceNetworkInterface").add("Association", (Object)this.association()).add("Attachment", (Object)this.attachment()).add("Description", (Object)this.description()).add("Groups", this.groups()).add("Ipv6Addresses", this.ipv6Addresses()).add("MacAddress", (Object)this.macAddress()).add("NetworkInterfaceId", (Object)this.networkInterfaceId()).add("OwnerId", (Object)this.ownerId()).add("PrivateDnsName", (Object)this.privateDnsName()).add("PrivateIpAddress", (Object)this.privateIpAddress()).add("PrivateIpAddresses", this.privateIpAddresses()).add("SourceDestCheck", (Object)this.sourceDestCheck()).add("Status", (Object)this.statusAsString()).add("SubnetId", (Object)this.subnetId()).add("VpcId", (Object)this.vpcId()).add("InterfaceType", (Object)this.interfaceType()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Association": {
                return Optional.ofNullable(clazz.cast(this.association()));
            }
            case "Attachment": {
                return Optional.ofNullable(clazz.cast(this.attachment()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Groups": {
                return Optional.ofNullable(clazz.cast(this.groups()));
            }
            case "Ipv6Addresses": {
                return Optional.ofNullable(clazz.cast(this.ipv6Addresses()));
            }
            case "MacAddress": {
                return Optional.ofNullable(clazz.cast(this.macAddress()));
            }
            case "NetworkInterfaceId": {
                return Optional.ofNullable(clazz.cast(this.networkInterfaceId()));
            }
            case "OwnerId": {
                return Optional.ofNullable(clazz.cast(this.ownerId()));
            }
            case "PrivateDnsName": {
                return Optional.ofNullable(clazz.cast(this.privateDnsName()));
            }
            case "PrivateIpAddress": {
                return Optional.ofNullable(clazz.cast(this.privateIpAddress()));
            }
            case "PrivateIpAddresses": {
                return Optional.ofNullable(clazz.cast(this.privateIpAddresses()));
            }
            case "SourceDestCheck": {
                return Optional.ofNullable(clazz.cast(this.sourceDestCheck()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "SubnetId": {
                return Optional.ofNullable(clazz.cast(this.subnetId()));
            }
            case "VpcId": {
                return Optional.ofNullable(clazz.cast(this.vpcId()));
            }
            case "InterfaceType": {
                return Optional.ofNullable(clazz.cast(this.interfaceType()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InstanceNetworkInterface, T> g) {
        return obj -> g.apply((InstanceNetworkInterface)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private InstanceNetworkInterfaceAssociation association;
        private InstanceNetworkInterfaceAttachment attachment;
        private String description;
        private List<GroupIdentifier> groups = DefaultSdkAutoConstructList.getInstance();
        private List<InstanceIpv6Address> ipv6Addresses = DefaultSdkAutoConstructList.getInstance();
        private String macAddress;
        private String networkInterfaceId;
        private String ownerId;
        private String privateDnsName;
        private String privateIpAddress;
        private List<InstancePrivateIpAddress> privateIpAddresses = DefaultSdkAutoConstructList.getInstance();
        private Boolean sourceDestCheck;
        private String status;
        private String subnetId;
        private String vpcId;
        private String interfaceType;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceNetworkInterface model) {
            this.association(model.association);
            this.attachment(model.attachment);
            this.description(model.description);
            this.groups(model.groups);
            this.ipv6Addresses(model.ipv6Addresses);
            this.macAddress(model.macAddress);
            this.networkInterfaceId(model.networkInterfaceId);
            this.ownerId(model.ownerId);
            this.privateDnsName(model.privateDnsName);
            this.privateIpAddress(model.privateIpAddress);
            this.privateIpAddresses(model.privateIpAddresses);
            this.sourceDestCheck(model.sourceDestCheck);
            this.status(model.status);
            this.subnetId(model.subnetId);
            this.vpcId(model.vpcId);
            this.interfaceType(model.interfaceType);
        }

        public final InstanceNetworkInterfaceAssociation.Builder getAssociation() {
            return this.association != null ? this.association.toBuilder() : null;
        }

        @Override
        public final Builder association(InstanceNetworkInterfaceAssociation association) {
            this.association = association;
            return this;
        }

        public final void setAssociation(InstanceNetworkInterfaceAssociation.BuilderImpl association) {
            this.association = association != null ? association.build() : null;
        }

        public final InstanceNetworkInterfaceAttachment.Builder getAttachment() {
            return this.attachment != null ? this.attachment.toBuilder() : null;
        }

        @Override
        public final Builder attachment(InstanceNetworkInterfaceAttachment attachment) {
            this.attachment = attachment;
            return this;
        }

        public final void setAttachment(InstanceNetworkInterfaceAttachment.BuilderImpl attachment) {
            this.attachment = attachment != null ? attachment.build() : null;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Collection<GroupIdentifier.Builder> getGroups() {
            return this.groups != null ? (Collection)this.groups.stream().map(GroupIdentifier::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder groups(Collection<GroupIdentifier> groups) {
            this.groups = GroupIdentifierListCopier.copy(groups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groups(GroupIdentifier ... groups) {
            this.groups(Arrays.asList(groups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groups(Consumer<GroupIdentifier.Builder> ... groups) {
            this.groups(Stream.of(groups).map(c -> (GroupIdentifier)((GroupIdentifier.Builder)GroupIdentifier.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setGroups(Collection<GroupIdentifier.BuilderImpl> groups) {
            this.groups = GroupIdentifierListCopier.copyFromBuilder(groups);
        }

        public final Collection<InstanceIpv6Address.Builder> getIpv6Addresses() {
            return this.ipv6Addresses != null ? (Collection)this.ipv6Addresses.stream().map(InstanceIpv6Address::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder ipv6Addresses(Collection<InstanceIpv6Address> ipv6Addresses) {
            this.ipv6Addresses = InstanceIpv6AddressListCopier.copy(ipv6Addresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipv6Addresses(InstanceIpv6Address ... ipv6Addresses) {
            this.ipv6Addresses(Arrays.asList(ipv6Addresses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipv6Addresses(Consumer<InstanceIpv6Address.Builder> ... ipv6Addresses) {
            this.ipv6Addresses(Stream.of(ipv6Addresses).map(c -> (InstanceIpv6Address)((InstanceIpv6Address.Builder)InstanceIpv6Address.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setIpv6Addresses(Collection<InstanceIpv6Address.BuilderImpl> ipv6Addresses) {
            this.ipv6Addresses = InstanceIpv6AddressListCopier.copyFromBuilder(ipv6Addresses);
        }

        public final String getMacAddress() {
            return this.macAddress;
        }

        @Override
        public final Builder macAddress(String macAddress) {
            this.macAddress = macAddress;
            return this;
        }

        public final void setMacAddress(String macAddress) {
            this.macAddress = macAddress;
        }

        public final String getNetworkInterfaceId() {
            return this.networkInterfaceId;
        }

        @Override
        public final Builder networkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
            return this;
        }

        public final void setNetworkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
        }

        public final String getOwnerId() {
            return this.ownerId;
        }

        @Override
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        public final String getPrivateDnsName() {
            return this.privateDnsName;
        }

        @Override
        public final Builder privateDnsName(String privateDnsName) {
            this.privateDnsName = privateDnsName;
            return this;
        }

        public final void setPrivateDnsName(String privateDnsName) {
            this.privateDnsName = privateDnsName;
        }

        public final String getPrivateIpAddress() {
            return this.privateIpAddress;
        }

        @Override
        public final Builder privateIpAddress(String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
            return this;
        }

        public final void setPrivateIpAddress(String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
        }

        public final Collection<InstancePrivateIpAddress.Builder> getPrivateIpAddresses() {
            return this.privateIpAddresses != null ? (Collection)this.privateIpAddresses.stream().map(InstancePrivateIpAddress::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder privateIpAddresses(Collection<InstancePrivateIpAddress> privateIpAddresses) {
            this.privateIpAddresses = InstancePrivateIpAddressListCopier.copy(privateIpAddresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder privateIpAddresses(InstancePrivateIpAddress ... privateIpAddresses) {
            this.privateIpAddresses(Arrays.asList(privateIpAddresses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder privateIpAddresses(Consumer<InstancePrivateIpAddress.Builder> ... privateIpAddresses) {
            this.privateIpAddresses(Stream.of(privateIpAddresses).map(c -> (InstancePrivateIpAddress)((InstancePrivateIpAddress.Builder)InstancePrivateIpAddress.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPrivateIpAddresses(Collection<InstancePrivateIpAddress.BuilderImpl> privateIpAddresses) {
            this.privateIpAddresses = InstancePrivateIpAddressListCopier.copyFromBuilder(privateIpAddresses);
        }

        public final Boolean getSourceDestCheck() {
            return this.sourceDestCheck;
        }

        @Override
        public final Builder sourceDestCheck(Boolean sourceDestCheck) {
            this.sourceDestCheck = sourceDestCheck;
            return this;
        }

        public final void setSourceDestCheck(Boolean sourceDestCheck) {
            this.sourceDestCheck = sourceDestCheck;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(NetworkInterfaceStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getSubnetId() {
            return this.subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        public final String getInterfaceType() {
            return this.interfaceType;
        }

        @Override
        public final Builder interfaceType(String interfaceType) {
            this.interfaceType = interfaceType;
            return this;
        }

        public final void setInterfaceType(String interfaceType) {
            this.interfaceType = interfaceType;
        }

        public InstanceNetworkInterface build() {
            return new InstanceNetworkInterface(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InstanceNetworkInterface> {
        public Builder association(InstanceNetworkInterfaceAssociation var1);

        default public Builder association(Consumer<InstanceNetworkInterfaceAssociation.Builder> association) {
            return this.association((InstanceNetworkInterfaceAssociation)((InstanceNetworkInterfaceAssociation.Builder)InstanceNetworkInterfaceAssociation.builder().applyMutation(association)).build());
        }

        public Builder attachment(InstanceNetworkInterfaceAttachment var1);

        default public Builder attachment(Consumer<InstanceNetworkInterfaceAttachment.Builder> attachment) {
            return this.attachment((InstanceNetworkInterfaceAttachment)((InstanceNetworkInterfaceAttachment.Builder)InstanceNetworkInterfaceAttachment.builder().applyMutation(attachment)).build());
        }

        public Builder description(String var1);

        public Builder groups(Collection<GroupIdentifier> var1);

        public Builder groups(GroupIdentifier ... var1);

        public Builder groups(Consumer<GroupIdentifier.Builder> ... var1);

        public Builder ipv6Addresses(Collection<InstanceIpv6Address> var1);

        public Builder ipv6Addresses(InstanceIpv6Address ... var1);

        public Builder ipv6Addresses(Consumer<InstanceIpv6Address.Builder> ... var1);

        public Builder macAddress(String var1);

        public Builder networkInterfaceId(String var1);

        public Builder ownerId(String var1);

        public Builder privateDnsName(String var1);

        public Builder privateIpAddress(String var1);

        public Builder privateIpAddresses(Collection<InstancePrivateIpAddress> var1);

        public Builder privateIpAddresses(InstancePrivateIpAddress ... var1);

        public Builder privateIpAddresses(Consumer<InstancePrivateIpAddress.Builder> ... var1);

        public Builder sourceDestCheck(Boolean var1);

        public Builder status(String var1);

        public Builder status(NetworkInterfaceStatus var1);

        public Builder subnetId(String var1);

        public Builder vpcId(String var1);

        public Builder interfaceType(String var1);
    }
}

