/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.Filter;
import software.amazon.awssdk.services.ec2.model.FilterListCopier;
import software.amazon.awssdk.services.ec2.model.TrafficMirrorFilterIdListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeTrafficMirrorFiltersRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, DescribeTrafficMirrorFiltersRequest> {
    private static final SdkField<List<String>> TRAFFIC_MIRROR_FILTER_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeTrafficMirrorFiltersRequest.getter(DescribeTrafficMirrorFiltersRequest::trafficMirrorFilterIds)).setter(DescribeTrafficMirrorFiltersRequest.setter(Builder::trafficMirrorFilterIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrafficMirrorFilterId").unmarshallLocationName("TrafficMirrorFilterId").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<List<Filter>> FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeTrafficMirrorFiltersRequest.getter(DescribeTrafficMirrorFiltersRequest::filters)).setter(DescribeTrafficMirrorFiltersRequest.setter(Builder::filters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter").unmarshallLocationName("Filter").build(), ListTrait.builder().memberLocationName("Filter").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Filter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter").unmarshallLocationName("Filter").build()}).build()).build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(DescribeTrafficMirrorFiltersRequest.getter(DescribeTrafficMirrorFiltersRequest::maxResults)).setter(DescribeTrafficMirrorFiltersRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").unmarshallLocationName("MaxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeTrafficMirrorFiltersRequest.getter(DescribeTrafficMirrorFiltersRequest::nextToken)).setter(DescribeTrafficMirrorFiltersRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRAFFIC_MIRROR_FILTER_IDS_FIELD, FILTERS_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));
    private final List<String> trafficMirrorFilterIds;
    private final List<Filter> filters;
    private final Integer maxResults;
    private final String nextToken;

    private DescribeTrafficMirrorFiltersRequest(BuilderImpl builder) {
        super(builder);
        this.trafficMirrorFilterIds = builder.trafficMirrorFilterIds;
        this.filters = builder.filters;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    public boolean hasTrafficMirrorFilterIds() {
        return this.trafficMirrorFilterIds != null && !(this.trafficMirrorFilterIds instanceof SdkAutoConstructList);
    }

    public List<String> trafficMirrorFilterIds() {
        return this.trafficMirrorFilterIds;
    }

    public boolean hasFilters() {
        return this.filters != null && !(this.filters instanceof SdkAutoConstructList);
    }

    public List<Filter> filters() {
        return this.filters;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    public String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.trafficMirrorFilterIds());
        hashCode = 31 * hashCode + Objects.hashCode(this.filters());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTrafficMirrorFiltersRequest)) {
            return false;
        }
        DescribeTrafficMirrorFiltersRequest other = (DescribeTrafficMirrorFiltersRequest)((Object)obj);
        return Objects.equals(this.trafficMirrorFilterIds(), other.trafficMirrorFilterIds()) && Objects.equals(this.filters(), other.filters()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeTrafficMirrorFiltersRequest").add("TrafficMirrorFilterIds", this.trafficMirrorFilterIds()).add("Filters", this.filters()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TrafficMirrorFilterIds": {
                return Optional.ofNullable(clazz.cast(this.trafficMirrorFilterIds()));
            }
            case "Filters": {
                return Optional.ofNullable(clazz.cast(this.filters()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeTrafficMirrorFiltersRequest, T> g) {
        return obj -> g.apply((DescribeTrafficMirrorFiltersRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private List<String> trafficMirrorFilterIds = DefaultSdkAutoConstructList.getInstance();
        private List<Filter> filters = DefaultSdkAutoConstructList.getInstance();
        private Integer maxResults;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTrafficMirrorFiltersRequest model) {
            super(model);
            this.trafficMirrorFilterIds(model.trafficMirrorFilterIds);
            this.filters(model.filters);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
        }

        public final Collection<String> getTrafficMirrorFilterIds() {
            return this.trafficMirrorFilterIds;
        }

        @Override
        public final Builder trafficMirrorFilterIds(Collection<String> trafficMirrorFilterIds) {
            this.trafficMirrorFilterIds = TrafficMirrorFilterIdListCopier.copy(trafficMirrorFilterIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder trafficMirrorFilterIds(String ... trafficMirrorFilterIds) {
            this.trafficMirrorFilterIds(Arrays.asList(trafficMirrorFilterIds));
            return this;
        }

        public final void setTrafficMirrorFilterIds(Collection<String> trafficMirrorFilterIds) {
            this.trafficMirrorFilterIds = TrafficMirrorFilterIdListCopier.copy(trafficMirrorFilterIds);
        }

        public final Collection<Filter.Builder> getFilters() {
            return this.filters != null ? (Collection)this.filters.stream().map(Filter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter ... filters) {
            this.filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<Filter.Builder> ... filters) {
            this.filters(Stream.of(filters).map(c -> (Filter)((Filter.Builder)Filter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFilters(Collection<Filter.BuilderImpl> filters) {
            this.filters = FilterListCopier.copyFromBuilder(filters);
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeTrafficMirrorFiltersRequest build() {
            return new DescribeTrafficMirrorFiltersRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeTrafficMirrorFiltersRequest> {
        public Builder trafficMirrorFilterIds(Collection<String> var1);

        public Builder trafficMirrorFilterIds(String ... var1);

        public Builder filters(Collection<Filter> var1);

        public Builder filters(Filter ... var1);

        public Builder filters(Consumer<Filter.Builder> ... var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

