/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.LocalGateway;
import software.amazon.awssdk.services.ec2.model.LocalGatewaySetCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeLocalGatewaysResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, DescribeLocalGatewaysResponse> {
    private static final SdkField<List<LocalGateway>> LOCAL_GATEWAYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeLocalGatewaysResponse.getter(DescribeLocalGatewaysResponse::localGateways)).setter(DescribeLocalGatewaysResponse.setter(Builder::localGateways)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalGatewaySet").unmarshallLocationName("localGatewaySet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LocalGateway::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeLocalGatewaysResponse.getter(DescribeLocalGatewaysResponse::nextToken)).setter(DescribeLocalGatewaysResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOCAL_GATEWAYS_FIELD, NEXT_TOKEN_FIELD));
    private final List<LocalGateway> localGateways;
    private final String nextToken;

    private DescribeLocalGatewaysResponse(BuilderImpl builder) {
        super(builder);
        this.localGateways = builder.localGateways;
        this.nextToken = builder.nextToken;
    }

    public boolean hasLocalGateways() {
        return this.localGateways != null && !(this.localGateways instanceof SdkAutoConstructList);
    }

    public List<LocalGateway> localGateways() {
        return this.localGateways;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.localGateways());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeLocalGatewaysResponse)) {
            return false;
        }
        DescribeLocalGatewaysResponse other = (DescribeLocalGatewaysResponse)((Object)obj);
        return Objects.equals(this.localGateways(), other.localGateways()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeLocalGatewaysResponse").add("LocalGateways", this.localGateways()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LocalGateways": {
                return Optional.ofNullable(clazz.cast(this.localGateways()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeLocalGatewaysResponse, T> g) {
        return obj -> g.apply((DescribeLocalGatewaysResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<LocalGateway> localGateways = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeLocalGatewaysResponse model) {
            super(model);
            this.localGateways(model.localGateways);
            this.nextToken(model.nextToken);
        }

        public final Collection<LocalGateway.Builder> getLocalGateways() {
            return this.localGateways != null ? (Collection)this.localGateways.stream().map(LocalGateway::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder localGateways(Collection<LocalGateway> localGateways) {
            this.localGateways = LocalGatewaySetCopier.copy(localGateways);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder localGateways(LocalGateway ... localGateways) {
            this.localGateways(Arrays.asList(localGateways));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder localGateways(Consumer<LocalGateway.Builder> ... localGateways) {
            this.localGateways(Stream.of(localGateways).map(c -> (LocalGateway)((LocalGateway.Builder)LocalGateway.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setLocalGateways(Collection<LocalGateway.BuilderImpl> localGateways) {
            this.localGateways = LocalGatewaySetCopier.copyFromBuilder(localGateways);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeLocalGatewaysResponse build() {
            return new DescribeLocalGatewaysResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeLocalGatewaysResponse> {
        public Builder localGateways(Collection<LocalGateway> var1);

        public Builder localGateways(LocalGateway ... var1);

        public Builder localGateways(Consumer<LocalGateway.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

