/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.ResponseHostIdListCopier;
import software.amazon.awssdk.services.ec2.model.UnsuccessfulItem;
import software.amazon.awssdk.services.ec2.model.UnsuccessfulItemListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModifyHostsResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, ModifyHostsResponse> {
    private static final SdkField<List<String>> SUCCESSFUL_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ModifyHostsResponse.getter(ModifyHostsResponse::successful)).setter(ModifyHostsResponse.setter(Builder::successful)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Successful").unmarshallLocationName("successful").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<List<UnsuccessfulItem>> UNSUCCESSFUL_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ModifyHostsResponse.getter(ModifyHostsResponse::unsuccessful)).setter(ModifyHostsResponse.setter(Builder::unsuccessful)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Unsuccessful").unmarshallLocationName("unsuccessful").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(UnsuccessfulItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUCCESSFUL_FIELD, UNSUCCESSFUL_FIELD));
    private final List<String> successful;
    private final List<UnsuccessfulItem> unsuccessful;

    private ModifyHostsResponse(BuilderImpl builder) {
        super(builder);
        this.successful = builder.successful;
        this.unsuccessful = builder.unsuccessful;
    }

    public boolean hasSuccessful() {
        return this.successful != null && !(this.successful instanceof SdkAutoConstructList);
    }

    public List<String> successful() {
        return this.successful;
    }

    public boolean hasUnsuccessful() {
        return this.unsuccessful != null && !(this.unsuccessful instanceof SdkAutoConstructList);
    }

    public List<UnsuccessfulItem> unsuccessful() {
        return this.unsuccessful;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.successful());
        hashCode = 31 * hashCode + Objects.hashCode(this.unsuccessful());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyHostsResponse)) {
            return false;
        }
        ModifyHostsResponse other = (ModifyHostsResponse)((Object)obj);
        return Objects.equals(this.successful(), other.successful()) && Objects.equals(this.unsuccessful(), other.unsuccessful());
    }

    public String toString() {
        return ToString.builder((String)"ModifyHostsResponse").add("Successful", this.successful()).add("Unsuccessful", this.unsuccessful()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Successful": {
                return Optional.ofNullable(clazz.cast(this.successful()));
            }
            case "Unsuccessful": {
                return Optional.ofNullable(clazz.cast(this.unsuccessful()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyHostsResponse, T> g) {
        return obj -> g.apply((ModifyHostsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<String> successful = DefaultSdkAutoConstructList.getInstance();
        private List<UnsuccessfulItem> unsuccessful = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyHostsResponse model) {
            super(model);
            this.successful(model.successful);
            this.unsuccessful(model.unsuccessful);
        }

        public final Collection<String> getSuccessful() {
            return this.successful;
        }

        @Override
        public final Builder successful(Collection<String> successful) {
            this.successful = ResponseHostIdListCopier.copy(successful);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder successful(String ... successful) {
            this.successful(Arrays.asList(successful));
            return this;
        }

        public final void setSuccessful(Collection<String> successful) {
            this.successful = ResponseHostIdListCopier.copy(successful);
        }

        public final Collection<UnsuccessfulItem.Builder> getUnsuccessful() {
            return this.unsuccessful != null ? (Collection)this.unsuccessful.stream().map(UnsuccessfulItem::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder unsuccessful(Collection<UnsuccessfulItem> unsuccessful) {
            this.unsuccessful = UnsuccessfulItemListCopier.copy(unsuccessful);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unsuccessful(UnsuccessfulItem ... unsuccessful) {
            this.unsuccessful(Arrays.asList(unsuccessful));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unsuccessful(Consumer<UnsuccessfulItem.Builder> ... unsuccessful) {
            this.unsuccessful(Stream.of(unsuccessful).map(c -> (UnsuccessfulItem)((UnsuccessfulItem.Builder)UnsuccessfulItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setUnsuccessful(Collection<UnsuccessfulItem.BuilderImpl> unsuccessful) {
            this.unsuccessful = UnsuccessfulItemListCopier.copyFromBuilder(unsuccessful);
        }

        @Override
        public ModifyHostsResponse build() {
            return new ModifyHostsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ModifyHostsResponse> {
        public Builder successful(Collection<String> var1);

        public Builder successful(String ... var1);

        public Builder unsuccessful(Collection<UnsuccessfulItem> var1);

        public Builder unsuccessful(UnsuccessfulItem ... var1);

        public Builder unsuccessful(Consumer<UnsuccessfulItem.Builder> ... var1);
    }
}

