/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2AsyncClient;
import software.amazon.awssdk.services.ec2.model.DescribeInstanceTypeOfferingsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeInstanceTypeOfferingsResponse;
import software.amazon.awssdk.services.ec2.model.InstanceTypeOffering;

public class DescribeInstanceTypeOfferingsPublisher
implements SdkPublisher<DescribeInstanceTypeOfferingsResponse> {
    private final Ec2AsyncClient client;
    private final DescribeInstanceTypeOfferingsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeInstanceTypeOfferingsPublisher(Ec2AsyncClient client, DescribeInstanceTypeOfferingsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeInstanceTypeOfferingsPublisher(Ec2AsyncClient client, DescribeInstanceTypeOfferingsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeInstanceTypeOfferingsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeInstanceTypeOfferingsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<InstanceTypeOffering> instanceTypeOfferings() {
        Function<DescribeInstanceTypeOfferingsResponse, Iterator> getIterator = response -> {
            if (response != null && response.instanceTypeOfferings() != null) {
                return response.instanceTypeOfferings().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeInstanceTypeOfferingsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeInstanceTypeOfferingsResponseFetcher
    implements AsyncPageFetcher<DescribeInstanceTypeOfferingsResponse> {
        private DescribeInstanceTypeOfferingsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeInstanceTypeOfferingsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeInstanceTypeOfferingsResponse> nextPage(DescribeInstanceTypeOfferingsResponse previousPage) {
            if (previousPage == null) {
                return DescribeInstanceTypeOfferingsPublisher.this.client.describeInstanceTypeOfferings(DescribeInstanceTypeOfferingsPublisher.this.firstRequest);
            }
            return DescribeInstanceTypeOfferingsPublisher.this.client.describeInstanceTypeOfferings((DescribeInstanceTypeOfferingsRequest)((Object)DescribeInstanceTypeOfferingsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

