/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.VpcEndpoint;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateVpcEndpointResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, CreateVpcEndpointResponse> {
    private static final SdkField<VpcEndpoint> VPC_ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CreateVpcEndpointResponse.getter(CreateVpcEndpointResponse::vpcEndpoint)).setter(CreateVpcEndpointResponse.setter(Builder::vpcEndpoint)).constructor(VpcEndpoint::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcEndpoint").unmarshallLocationName("vpcEndpoint").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateVpcEndpointResponse.getter(CreateVpcEndpointResponse::clientToken)).setter(CreateVpcEndpointResponse.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").unmarshallLocationName("clientToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VPC_ENDPOINT_FIELD, CLIENT_TOKEN_FIELD));
    private final VpcEndpoint vpcEndpoint;
    private final String clientToken;

    private CreateVpcEndpointResponse(BuilderImpl builder) {
        super(builder);
        this.vpcEndpoint = builder.vpcEndpoint;
        this.clientToken = builder.clientToken;
    }

    public VpcEndpoint vpcEndpoint() {
        return this.vpcEndpoint;
    }

    public String clientToken() {
        return this.clientToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateVpcEndpointResponse)) {
            return false;
        }
        CreateVpcEndpointResponse other = (CreateVpcEndpointResponse)((Object)obj);
        return Objects.equals(this.vpcEndpoint(), other.vpcEndpoint()) && Objects.equals(this.clientToken(), other.clientToken());
    }

    public String toString() {
        return ToString.builder((String)"CreateVpcEndpointResponse").add("VpcEndpoint", (Object)this.vpcEndpoint()).add("ClientToken", (Object)this.clientToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VpcEndpoint": {
                return Optional.ofNullable(clazz.cast(this.vpcEndpoint()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateVpcEndpointResponse, T> g) {
        return obj -> g.apply((CreateVpcEndpointResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private VpcEndpoint vpcEndpoint;
        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateVpcEndpointResponse model) {
            super(model);
            this.vpcEndpoint(model.vpcEndpoint);
            this.clientToken(model.clientToken);
        }

        public final VpcEndpoint.Builder getVpcEndpoint() {
            return this.vpcEndpoint != null ? this.vpcEndpoint.toBuilder() : null;
        }

        @Override
        public final Builder vpcEndpoint(VpcEndpoint vpcEndpoint) {
            this.vpcEndpoint = vpcEndpoint;
            return this;
        }

        public final void setVpcEndpoint(VpcEndpoint.BuilderImpl vpcEndpoint) {
            this.vpcEndpoint = vpcEndpoint != null ? vpcEndpoint.build() : null;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public CreateVpcEndpointResponse build() {
            return new CreateVpcEndpointResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateVpcEndpointResponse> {
        public Builder vpcEndpoint(VpcEndpoint var1);

        default public Builder vpcEndpoint(Consumer<VpcEndpoint.Builder> vpcEndpoint) {
            return this.vpcEndpoint((VpcEndpoint)((VpcEndpoint.Builder)VpcEndpoint.builder().applyMutation(vpcEndpoint)).build());
        }

        public Builder clientToken(String var1);
    }
}

