/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.ResetFpgaImageAttributeName;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResetFpgaImageAttributeRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, ResetFpgaImageAttributeRequest> {
    private static final SdkField<String> FPGA_IMAGE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ResetFpgaImageAttributeRequest.getter(ResetFpgaImageAttributeRequest::fpgaImageId)).setter(ResetFpgaImageAttributeRequest.setter(Builder::fpgaImageId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FpgaImageId").unmarshallLocationName("FpgaImageId").build()}).build();
    private static final SdkField<String> ATTRIBUTE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ResetFpgaImageAttributeRequest.getter(ResetFpgaImageAttributeRequest::attributeAsString)).setter(ResetFpgaImageAttributeRequest.setter(Builder::attribute)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attribute").unmarshallLocationName("Attribute").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FPGA_IMAGE_ID_FIELD, ATTRIBUTE_FIELD));
    private final String fpgaImageId;
    private final String attribute;

    private ResetFpgaImageAttributeRequest(BuilderImpl builder) {
        super(builder);
        this.fpgaImageId = builder.fpgaImageId;
        this.attribute = builder.attribute;
    }

    public String fpgaImageId() {
        return this.fpgaImageId;
    }

    public ResetFpgaImageAttributeName attribute() {
        return ResetFpgaImageAttributeName.fromValue(this.attribute);
    }

    public String attributeAsString() {
        return this.attribute;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.fpgaImageId());
        hashCode = 31 * hashCode + Objects.hashCode(this.attributeAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResetFpgaImageAttributeRequest)) {
            return false;
        }
        ResetFpgaImageAttributeRequest other = (ResetFpgaImageAttributeRequest)((Object)obj);
        return Objects.equals(this.fpgaImageId(), other.fpgaImageId()) && Objects.equals(this.attributeAsString(), other.attributeAsString());
    }

    public String toString() {
        return ToString.builder((String)"ResetFpgaImageAttributeRequest").add("FpgaImageId", (Object)this.fpgaImageId()).add("Attribute", (Object)this.attributeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FpgaImageId": {
                return Optional.ofNullable(clazz.cast(this.fpgaImageId()));
            }
            case "Attribute": {
                return Optional.ofNullable(clazz.cast(this.attributeAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResetFpgaImageAttributeRequest, T> g) {
        return obj -> g.apply((ResetFpgaImageAttributeRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private String fpgaImageId;
        private String attribute;

        private BuilderImpl() {
        }

        private BuilderImpl(ResetFpgaImageAttributeRequest model) {
            super(model);
            this.fpgaImageId(model.fpgaImageId);
            this.attribute(model.attribute);
        }

        public final String getFpgaImageId() {
            return this.fpgaImageId;
        }

        @Override
        public final Builder fpgaImageId(String fpgaImageId) {
            this.fpgaImageId = fpgaImageId;
            return this;
        }

        public final void setFpgaImageId(String fpgaImageId) {
            this.fpgaImageId = fpgaImageId;
        }

        public final String getAttribute() {
            return this.attribute;
        }

        @Override
        public final Builder attribute(String attribute) {
            this.attribute = attribute;
            return this;
        }

        @Override
        public final Builder attribute(ResetFpgaImageAttributeName attribute) {
            this.attribute(attribute == null ? null : attribute.toString());
            return this;
        }

        public final void setAttribute(String attribute) {
            this.attribute = attribute;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ResetFpgaImageAttributeRequest build() {
            return new ResetFpgaImageAttributeRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ResetFpgaImageAttributeRequest> {
        public Builder fpgaImageId(String var1);

        public Builder attribute(String var1);

        public Builder attribute(ResetFpgaImageAttributeName var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

