/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.Filter;
import software.amazon.awssdk.services.ec2.model.FilterListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeReservedInstancesListingsRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, DescribeReservedInstancesListingsRequest> {
    private static final SdkField<List<Filter>> FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeReservedInstancesListingsRequest.getter(DescribeReservedInstancesListingsRequest::filters)).setter(DescribeReservedInstancesListingsRequest.setter(Builder::filters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter").unmarshallLocationName("Filter").build(), ListTrait.builder().memberLocationName("Filter").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Filter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter").unmarshallLocationName("Filter").build()}).build()).build()}).build();
    private static final SdkField<String> RESERVED_INSTANCES_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeReservedInstancesListingsRequest.getter(DescribeReservedInstancesListingsRequest::reservedInstancesId)).setter(DescribeReservedInstancesListingsRequest.setter(Builder::reservedInstancesId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservedInstancesId").unmarshallLocationName("reservedInstancesId").build()}).build();
    private static final SdkField<String> RESERVED_INSTANCES_LISTING_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeReservedInstancesListingsRequest.getter(DescribeReservedInstancesListingsRequest::reservedInstancesListingId)).setter(DescribeReservedInstancesListingsRequest.setter(Builder::reservedInstancesListingId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservedInstancesListingId").unmarshallLocationName("reservedInstancesListingId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTERS_FIELD, RESERVED_INSTANCES_ID_FIELD, RESERVED_INSTANCES_LISTING_ID_FIELD));
    private final List<Filter> filters;
    private final String reservedInstancesId;
    private final String reservedInstancesListingId;

    private DescribeReservedInstancesListingsRequest(BuilderImpl builder) {
        super(builder);
        this.filters = builder.filters;
        this.reservedInstancesId = builder.reservedInstancesId;
        this.reservedInstancesListingId = builder.reservedInstancesListingId;
    }

    public boolean hasFilters() {
        return this.filters != null && !(this.filters instanceof SdkAutoConstructList);
    }

    public List<Filter> filters() {
        return this.filters;
    }

    public String reservedInstancesId() {
        return this.reservedInstancesId;
    }

    public String reservedInstancesListingId() {
        return this.reservedInstancesListingId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.filters());
        hashCode = 31 * hashCode + Objects.hashCode(this.reservedInstancesId());
        hashCode = 31 * hashCode + Objects.hashCode(this.reservedInstancesListingId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeReservedInstancesListingsRequest)) {
            return false;
        }
        DescribeReservedInstancesListingsRequest other = (DescribeReservedInstancesListingsRequest)((Object)obj);
        return Objects.equals(this.filters(), other.filters()) && Objects.equals(this.reservedInstancesId(), other.reservedInstancesId()) && Objects.equals(this.reservedInstancesListingId(), other.reservedInstancesListingId());
    }

    public String toString() {
        return ToString.builder((String)"DescribeReservedInstancesListingsRequest").add("Filters", this.filters()).add("ReservedInstancesId", (Object)this.reservedInstancesId()).add("ReservedInstancesListingId", (Object)this.reservedInstancesListingId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Filters": {
                return Optional.ofNullable(clazz.cast(this.filters()));
            }
            case "ReservedInstancesId": {
                return Optional.ofNullable(clazz.cast(this.reservedInstancesId()));
            }
            case "ReservedInstancesListingId": {
                return Optional.ofNullable(clazz.cast(this.reservedInstancesListingId()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeReservedInstancesListingsRequest, T> g) {
        return obj -> g.apply((DescribeReservedInstancesListingsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private List<Filter> filters = DefaultSdkAutoConstructList.getInstance();
        private String reservedInstancesId;
        private String reservedInstancesListingId;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeReservedInstancesListingsRequest model) {
            super(model);
            this.filters(model.filters);
            this.reservedInstancesId(model.reservedInstancesId);
            this.reservedInstancesListingId(model.reservedInstancesListingId);
        }

        public final Collection<Filter.Builder> getFilters() {
            return this.filters != null ? (Collection)this.filters.stream().map(Filter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter ... filters) {
            this.filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<Filter.Builder> ... filters) {
            this.filters(Stream.of(filters).map(c -> (Filter)((Filter.Builder)Filter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFilters(Collection<Filter.BuilderImpl> filters) {
            this.filters = FilterListCopier.copyFromBuilder(filters);
        }

        public final String getReservedInstancesId() {
            return this.reservedInstancesId;
        }

        @Override
        public final Builder reservedInstancesId(String reservedInstancesId) {
            this.reservedInstancesId = reservedInstancesId;
            return this;
        }

        public final void setReservedInstancesId(String reservedInstancesId) {
            this.reservedInstancesId = reservedInstancesId;
        }

        public final String getReservedInstancesListingId() {
            return this.reservedInstancesListingId;
        }

        @Override
        public final Builder reservedInstancesListingId(String reservedInstancesListingId) {
            this.reservedInstancesListingId = reservedInstancesListingId;
            return this;
        }

        public final void setReservedInstancesListingId(String reservedInstancesListingId) {
            this.reservedInstancesListingId = reservedInstancesListingId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeReservedInstancesListingsRequest build() {
            return new DescribeReservedInstancesListingsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeReservedInstancesListingsRequest> {
        public Builder filters(Collection<Filter> var1);

        public Builder filters(Filter ... var1);

        public Builder filters(Consumer<Filter.Builder> ... var1);

        public Builder reservedInstancesId(String var1);

        public Builder reservedInstancesListingId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

