/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.model.DescribeEgressOnlyInternetGatewaysRequest;
import software.amazon.awssdk.services.ec2.model.DescribeEgressOnlyInternetGatewaysResponse;
import software.amazon.awssdk.services.ec2.model.EgressOnlyInternetGateway;

public class DescribeEgressOnlyInternetGatewaysIterable
implements SdkIterable<DescribeEgressOnlyInternetGatewaysResponse> {
    private final Ec2Client client;
    private final DescribeEgressOnlyInternetGatewaysRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeEgressOnlyInternetGatewaysIterable(Ec2Client client, DescribeEgressOnlyInternetGatewaysRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeEgressOnlyInternetGatewaysResponseFetcher();
    }

    public Iterator<DescribeEgressOnlyInternetGatewaysResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<EgressOnlyInternetGateway> egressOnlyInternetGateways() {
        Function<DescribeEgressOnlyInternetGatewaysResponse, Iterator> getIterator = response -> {
            if (response != null && response.egressOnlyInternetGateways() != null) {
                return response.egressOnlyInternetGateways().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeEgressOnlyInternetGatewaysResponseFetcher
    implements SyncPageFetcher<DescribeEgressOnlyInternetGatewaysResponse> {
        private DescribeEgressOnlyInternetGatewaysResponseFetcher() {
        }

        public boolean hasNextPage(DescribeEgressOnlyInternetGatewaysResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeEgressOnlyInternetGatewaysResponse nextPage(DescribeEgressOnlyInternetGatewaysResponse previousPage) {
            if (previousPage == null) {
                return DescribeEgressOnlyInternetGatewaysIterable.this.client.describeEgressOnlyInternetGateways(DescribeEgressOnlyInternetGatewaysIterable.this.firstRequest);
            }
            return DescribeEgressOnlyInternetGatewaysIterable.this.client.describeEgressOnlyInternetGateways((DescribeEgressOnlyInternetGatewaysRequest)((Object)DescribeEgressOnlyInternetGatewaysIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

