/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.AvailabilityZoneMessage;
import software.amazon.awssdk.services.ec2.model.AvailabilityZoneMessageListCopier;
import software.amazon.awssdk.services.ec2.model.AvailabilityZoneOptInStatus;
import software.amazon.awssdk.services.ec2.model.AvailabilityZoneState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AvailabilityZone
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AvailabilityZone> {
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AvailabilityZone.getter(AvailabilityZone::stateAsString)).setter(AvailabilityZone.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ZoneState").unmarshallLocationName("zoneState").build()}).build();
    private static final SdkField<String> OPT_IN_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AvailabilityZone.getter(AvailabilityZone::optInStatusAsString)).setter(AvailabilityZone.setter(Builder::optInStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptInStatus").unmarshallLocationName("optInStatus").build()}).build();
    private static final SdkField<List<AvailabilityZoneMessage>> MESSAGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(AvailabilityZone.getter(AvailabilityZone::messages)).setter(AvailabilityZone.setter(Builder::messages)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MessageSet").unmarshallLocationName("messageSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AvailabilityZoneMessage::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> REGION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AvailabilityZone.getter(AvailabilityZone::regionName)).setter(AvailabilityZone.setter(Builder::regionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegionName").unmarshallLocationName("regionName").build()}).build();
    private static final SdkField<String> ZONE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AvailabilityZone.getter(AvailabilityZone::zoneName)).setter(AvailabilityZone.setter(Builder::zoneName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ZoneName").unmarshallLocationName("zoneName").build()}).build();
    private static final SdkField<String> ZONE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AvailabilityZone.getter(AvailabilityZone::zoneId)).setter(AvailabilityZone.setter(Builder::zoneId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ZoneId").unmarshallLocationName("zoneId").build()}).build();
    private static final SdkField<String> GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AvailabilityZone.getter(AvailabilityZone::groupName)).setter(AvailabilityZone.setter(Builder::groupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupName").unmarshallLocationName("groupName").build()}).build();
    private static final SdkField<String> NETWORK_BORDER_GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AvailabilityZone.getter(AvailabilityZone::networkBorderGroup)).setter(AvailabilityZone.setter(Builder::networkBorderGroup)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkBorderGroup").unmarshallLocationName("networkBorderGroup").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATE_FIELD, OPT_IN_STATUS_FIELD, MESSAGES_FIELD, REGION_NAME_FIELD, ZONE_NAME_FIELD, ZONE_ID_FIELD, GROUP_NAME_FIELD, NETWORK_BORDER_GROUP_FIELD));
    private static final long serialVersionUID = 1L;
    private final String state;
    private final String optInStatus;
    private final List<AvailabilityZoneMessage> messages;
    private final String regionName;
    private final String zoneName;
    private final String zoneId;
    private final String groupName;
    private final String networkBorderGroup;

    private AvailabilityZone(BuilderImpl builder) {
        this.state = builder.state;
        this.optInStatus = builder.optInStatus;
        this.messages = builder.messages;
        this.regionName = builder.regionName;
        this.zoneName = builder.zoneName;
        this.zoneId = builder.zoneId;
        this.groupName = builder.groupName;
        this.networkBorderGroup = builder.networkBorderGroup;
    }

    public AvailabilityZoneState state() {
        return AvailabilityZoneState.fromValue(this.state);
    }

    public String stateAsString() {
        return this.state;
    }

    public AvailabilityZoneOptInStatus optInStatus() {
        return AvailabilityZoneOptInStatus.fromValue(this.optInStatus);
    }

    public String optInStatusAsString() {
        return this.optInStatus;
    }

    public boolean hasMessages() {
        return this.messages != null && !(this.messages instanceof SdkAutoConstructList);
    }

    public List<AvailabilityZoneMessage> messages() {
        return this.messages;
    }

    public String regionName() {
        return this.regionName;
    }

    public String zoneName() {
        return this.zoneName;
    }

    public String zoneId() {
        return this.zoneId;
    }

    public String groupName() {
        return this.groupName;
    }

    public String networkBorderGroup() {
        return this.networkBorderGroup;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.optInStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.messages());
        hashCode = 31 * hashCode + Objects.hashCode(this.regionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.zoneName());
        hashCode = 31 * hashCode + Objects.hashCode(this.zoneId());
        hashCode = 31 * hashCode + Objects.hashCode(this.groupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkBorderGroup());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AvailabilityZone)) {
            return false;
        }
        AvailabilityZone other = (AvailabilityZone)obj;
        return Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.optInStatusAsString(), other.optInStatusAsString()) && Objects.equals(this.messages(), other.messages()) && Objects.equals(this.regionName(), other.regionName()) && Objects.equals(this.zoneName(), other.zoneName()) && Objects.equals(this.zoneId(), other.zoneId()) && Objects.equals(this.groupName(), other.groupName()) && Objects.equals(this.networkBorderGroup(), other.networkBorderGroup());
    }

    public String toString() {
        return ToString.builder((String)"AvailabilityZone").add("State", (Object)this.stateAsString()).add("OptInStatus", (Object)this.optInStatusAsString()).add("Messages", this.messages()).add("RegionName", (Object)this.regionName()).add("ZoneName", (Object)this.zoneName()).add("ZoneId", (Object)this.zoneId()).add("GroupName", (Object)this.groupName()).add("NetworkBorderGroup", (Object)this.networkBorderGroup()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "OptInStatus": {
                return Optional.ofNullable(clazz.cast(this.optInStatusAsString()));
            }
            case "Messages": {
                return Optional.ofNullable(clazz.cast(this.messages()));
            }
            case "RegionName": {
                return Optional.ofNullable(clazz.cast(this.regionName()));
            }
            case "ZoneName": {
                return Optional.ofNullable(clazz.cast(this.zoneName()));
            }
            case "ZoneId": {
                return Optional.ofNullable(clazz.cast(this.zoneId()));
            }
            case "GroupName": {
                return Optional.ofNullable(clazz.cast(this.groupName()));
            }
            case "NetworkBorderGroup": {
                return Optional.ofNullable(clazz.cast(this.networkBorderGroup()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AvailabilityZone, T> g) {
        return obj -> g.apply((AvailabilityZone)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String state;
        private String optInStatus;
        private List<AvailabilityZoneMessage> messages = DefaultSdkAutoConstructList.getInstance();
        private String regionName;
        private String zoneName;
        private String zoneId;
        private String groupName;
        private String networkBorderGroup;

        private BuilderImpl() {
        }

        private BuilderImpl(AvailabilityZone model) {
            this.state(model.state);
            this.optInStatus(model.optInStatus);
            this.messages(model.messages);
            this.regionName(model.regionName);
            this.zoneName(model.zoneName);
            this.zoneId(model.zoneId);
            this.groupName(model.groupName);
            this.networkBorderGroup(model.networkBorderGroup);
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(AvailabilityZoneState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final String getOptInStatus() {
            return this.optInStatus;
        }

        @Override
        public final Builder optInStatus(String optInStatus) {
            this.optInStatus = optInStatus;
            return this;
        }

        @Override
        public final Builder optInStatus(AvailabilityZoneOptInStatus optInStatus) {
            this.optInStatus(optInStatus == null ? null : optInStatus.toString());
            return this;
        }

        public final void setOptInStatus(String optInStatus) {
            this.optInStatus = optInStatus;
        }

        public final Collection<AvailabilityZoneMessage.Builder> getMessages() {
            return this.messages != null ? (Collection)this.messages.stream().map(AvailabilityZoneMessage::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder messages(Collection<AvailabilityZoneMessage> messages) {
            this.messages = AvailabilityZoneMessageListCopier.copy(messages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder messages(AvailabilityZoneMessage ... messages) {
            this.messages(Arrays.asList(messages));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder messages(Consumer<AvailabilityZoneMessage.Builder> ... messages) {
            this.messages(Stream.of(messages).map(c -> (AvailabilityZoneMessage)((AvailabilityZoneMessage.Builder)AvailabilityZoneMessage.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setMessages(Collection<AvailabilityZoneMessage.BuilderImpl> messages) {
            this.messages = AvailabilityZoneMessageListCopier.copyFromBuilder(messages);
        }

        public final String getRegionName() {
            return this.regionName;
        }

        @Override
        public final Builder regionName(String regionName) {
            this.regionName = regionName;
            return this;
        }

        public final void setRegionName(String regionName) {
            this.regionName = regionName;
        }

        public final String getZoneName() {
            return this.zoneName;
        }

        @Override
        public final Builder zoneName(String zoneName) {
            this.zoneName = zoneName;
            return this;
        }

        public final void setZoneName(String zoneName) {
            this.zoneName = zoneName;
        }

        public final String getZoneId() {
            return this.zoneId;
        }

        @Override
        public final Builder zoneId(String zoneId) {
            this.zoneId = zoneId;
            return this;
        }

        public final void setZoneId(String zoneId) {
            this.zoneId = zoneId;
        }

        public final String getGroupName() {
            return this.groupName;
        }

        @Override
        public final Builder groupName(String groupName) {
            this.groupName = groupName;
            return this;
        }

        public final void setGroupName(String groupName) {
            this.groupName = groupName;
        }

        public final String getNetworkBorderGroup() {
            return this.networkBorderGroup;
        }

        @Override
        public final Builder networkBorderGroup(String networkBorderGroup) {
            this.networkBorderGroup = networkBorderGroup;
            return this;
        }

        public final void setNetworkBorderGroup(String networkBorderGroup) {
            this.networkBorderGroup = networkBorderGroup;
        }

        public AvailabilityZone build() {
            return new AvailabilityZone(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AvailabilityZone> {
        public Builder state(String var1);

        public Builder state(AvailabilityZoneState var1);

        public Builder optInStatus(String var1);

        public Builder optInStatus(AvailabilityZoneOptInStatus var1);

        public Builder messages(Collection<AvailabilityZoneMessage> var1);

        public Builder messages(AvailabilityZoneMessage ... var1);

        public Builder messages(Consumer<AvailabilityZoneMessage.Builder> ... var1);

        public Builder regionName(String var1);

        public Builder zoneName(String var1);

        public Builder zoneId(String var1);

        public Builder groupName(String var1);

        public Builder networkBorderGroup(String var1);
    }
}

