/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.model.DescribeFleetsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeFleetsResponse;
import software.amazon.awssdk.services.ec2.model.FleetData;

public class DescribeFleetsIterable
implements SdkIterable<DescribeFleetsResponse> {
    private final Ec2Client client;
    private final DescribeFleetsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeFleetsIterable(Ec2Client client, DescribeFleetsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeFleetsResponseFetcher();
    }

    public Iterator<DescribeFleetsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<FleetData> fleets() {
        Function<DescribeFleetsResponse, Iterator> getIterator = response -> {
            if (response != null && response.fleets() != null) {
                return response.fleets().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeFleetsResponseFetcher
    implements SyncPageFetcher<DescribeFleetsResponse> {
        private DescribeFleetsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeFleetsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeFleetsResponse nextPage(DescribeFleetsResponse previousPage) {
            if (previousPage == null) {
                return DescribeFleetsIterable.this.client.describeFleets(DescribeFleetsIterable.this.firstRequest);
            }
            return DescribeFleetsIterable.this.client.describeFleets((DescribeFleetsRequest)((Object)DescribeFleetsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

