/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.GroupIdentifier;
import software.amazon.awssdk.services.ec2.model.GroupIdentifierListCopier;
import software.amazon.awssdk.services.ec2.model.Instance;
import software.amazon.awssdk.services.ec2.model.InstanceListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RunInstancesResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, RunInstancesResponse> {
    private static final SdkField<List<GroupIdentifier>> GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(RunInstancesResponse.getter(RunInstancesResponse::groups)).setter(RunInstancesResponse.setter(Builder::groups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupSet").unmarshallLocationName("groupSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(GroupIdentifier::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<List<Instance>> INSTANCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(RunInstancesResponse.getter(RunInstancesResponse::instances)).setter(RunInstancesResponse.setter(Builder::instances)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstancesSet").unmarshallLocationName("instancesSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Instance::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> OWNER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RunInstancesResponse.getter(RunInstancesResponse::ownerId)).setter(RunInstancesResponse.setter(Builder::ownerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerId").unmarshallLocationName("ownerId").build()}).build();
    private static final SdkField<String> REQUESTER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RunInstancesResponse.getter(RunInstancesResponse::requesterId)).setter(RunInstancesResponse.setter(Builder::requesterId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequesterId").unmarshallLocationName("requesterId").build()}).build();
    private static final SdkField<String> RESERVATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RunInstancesResponse.getter(RunInstancesResponse::reservationId)).setter(RunInstancesResponse.setter(Builder::reservationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservationId").unmarshallLocationName("reservationId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUPS_FIELD, INSTANCES_FIELD, OWNER_ID_FIELD, REQUESTER_ID_FIELD, RESERVATION_ID_FIELD));
    private final List<GroupIdentifier> groups;
    private final List<Instance> instances;
    private final String ownerId;
    private final String requesterId;
    private final String reservationId;

    private RunInstancesResponse(BuilderImpl builder) {
        super(builder);
        this.groups = builder.groups;
        this.instances = builder.instances;
        this.ownerId = builder.ownerId;
        this.requesterId = builder.requesterId;
        this.reservationId = builder.reservationId;
    }

    public boolean hasGroups() {
        return this.groups != null && !(this.groups instanceof SdkAutoConstructList);
    }

    public List<GroupIdentifier> groups() {
        return this.groups;
    }

    public boolean hasInstances() {
        return this.instances != null && !(this.instances instanceof SdkAutoConstructList);
    }

    public List<Instance> instances() {
        return this.instances;
    }

    public String ownerId() {
        return this.ownerId;
    }

    public String requesterId() {
        return this.requesterId;
    }

    public String reservationId() {
        return this.reservationId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.groups());
        hashCode = 31 * hashCode + Objects.hashCode(this.instances());
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.requesterId());
        hashCode = 31 * hashCode + Objects.hashCode(this.reservationId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RunInstancesResponse)) {
            return false;
        }
        RunInstancesResponse other = (RunInstancesResponse)((Object)obj);
        return Objects.equals(this.groups(), other.groups()) && Objects.equals(this.instances(), other.instances()) && Objects.equals(this.ownerId(), other.ownerId()) && Objects.equals(this.requesterId(), other.requesterId()) && Objects.equals(this.reservationId(), other.reservationId());
    }

    public String toString() {
        return ToString.builder((String)"RunInstancesResponse").add("Groups", this.groups()).add("Instances", this.instances()).add("OwnerId", (Object)this.ownerId()).add("RequesterId", (Object)this.requesterId()).add("ReservationId", (Object)this.reservationId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Groups": {
                return Optional.ofNullable(clazz.cast(this.groups()));
            }
            case "Instances": {
                return Optional.ofNullable(clazz.cast(this.instances()));
            }
            case "OwnerId": {
                return Optional.ofNullable(clazz.cast(this.ownerId()));
            }
            case "RequesterId": {
                return Optional.ofNullable(clazz.cast(this.requesterId()));
            }
            case "ReservationId": {
                return Optional.ofNullable(clazz.cast(this.reservationId()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RunInstancesResponse, T> g) {
        return obj -> g.apply((RunInstancesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<GroupIdentifier> groups = DefaultSdkAutoConstructList.getInstance();
        private List<Instance> instances = DefaultSdkAutoConstructList.getInstance();
        private String ownerId;
        private String requesterId;
        private String reservationId;

        private BuilderImpl() {
        }

        private BuilderImpl(RunInstancesResponse model) {
            super(model);
            this.groups(model.groups);
            this.instances(model.instances);
            this.ownerId(model.ownerId);
            this.requesterId(model.requesterId);
            this.reservationId(model.reservationId);
        }

        public final Collection<GroupIdentifier.Builder> getGroups() {
            return this.groups != null ? (Collection)this.groups.stream().map(GroupIdentifier::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder groups(Collection<GroupIdentifier> groups) {
            this.groups = GroupIdentifierListCopier.copy(groups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groups(GroupIdentifier ... groups) {
            this.groups(Arrays.asList(groups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groups(Consumer<GroupIdentifier.Builder> ... groups) {
            this.groups(Stream.of(groups).map(c -> (GroupIdentifier)((GroupIdentifier.Builder)GroupIdentifier.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setGroups(Collection<GroupIdentifier.BuilderImpl> groups) {
            this.groups = GroupIdentifierListCopier.copyFromBuilder(groups);
        }

        public final Collection<Instance.Builder> getInstances() {
            return this.instances != null ? (Collection)this.instances.stream().map(Instance::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder instances(Collection<Instance> instances) {
            this.instances = InstanceListCopier.copy(instances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instances(Instance ... instances) {
            this.instances(Arrays.asList(instances));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instances(Consumer<Instance.Builder> ... instances) {
            this.instances(Stream.of(instances).map(c -> (Instance)((Instance.Builder)Instance.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setInstances(Collection<Instance.BuilderImpl> instances) {
            this.instances = InstanceListCopier.copyFromBuilder(instances);
        }

        public final String getOwnerId() {
            return this.ownerId;
        }

        @Override
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        public final String getRequesterId() {
            return this.requesterId;
        }

        @Override
        public final Builder requesterId(String requesterId) {
            this.requesterId = requesterId;
            return this;
        }

        public final void setRequesterId(String requesterId) {
            this.requesterId = requesterId;
        }

        public final String getReservationId() {
            return this.reservationId;
        }

        @Override
        public final Builder reservationId(String reservationId) {
            this.reservationId = reservationId;
            return this;
        }

        public final void setReservationId(String reservationId) {
            this.reservationId = reservationId;
        }

        @Override
        public RunInstancesResponse build() {
            return new RunInstancesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RunInstancesResponse> {
        public Builder groups(Collection<GroupIdentifier> var1);

        public Builder groups(GroupIdentifier ... var1);

        public Builder groups(Consumer<GroupIdentifier.Builder> ... var1);

        public Builder instances(Collection<Instance> var1);

        public Builder instances(Instance ... var1);

        public Builder instances(Consumer<Instance.Builder> ... var1);

        public Builder ownerId(String var1);

        public Builder requesterId(String var1);

        public Builder reservationId(String var1);
    }
}

