/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.ClientVpnConnectionStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TerminateConnectionStatus
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TerminateConnectionStatus> {
    private static final SdkField<String> CONNECTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(TerminateConnectionStatus.getter(TerminateConnectionStatus::connectionId)).setter(TerminateConnectionStatus.setter(Builder::connectionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionId").unmarshallLocationName("connectionId").build()}).build();
    private static final SdkField<ClientVpnConnectionStatus> PREVIOUS_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(TerminateConnectionStatus.getter(TerminateConnectionStatus::previousStatus)).setter(TerminateConnectionStatus.setter(Builder::previousStatus)).constructor(ClientVpnConnectionStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreviousStatus").unmarshallLocationName("previousStatus").build()}).build();
    private static final SdkField<ClientVpnConnectionStatus> CURRENT_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(TerminateConnectionStatus.getter(TerminateConnectionStatus::currentStatus)).setter(TerminateConnectionStatus.setter(Builder::currentStatus)).constructor(ClientVpnConnectionStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentStatus").unmarshallLocationName("currentStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTION_ID_FIELD, PREVIOUS_STATUS_FIELD, CURRENT_STATUS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String connectionId;
    private final ClientVpnConnectionStatus previousStatus;
    private final ClientVpnConnectionStatus currentStatus;

    private TerminateConnectionStatus(BuilderImpl builder) {
        this.connectionId = builder.connectionId;
        this.previousStatus = builder.previousStatus;
        this.currentStatus = builder.currentStatus;
    }

    public String connectionId() {
        return this.connectionId;
    }

    public ClientVpnConnectionStatus previousStatus() {
        return this.previousStatus;
    }

    public ClientVpnConnectionStatus currentStatus() {
        return this.currentStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.previousStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.currentStatus());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TerminateConnectionStatus)) {
            return false;
        }
        TerminateConnectionStatus other = (TerminateConnectionStatus)obj;
        return Objects.equals(this.connectionId(), other.connectionId()) && Objects.equals(this.previousStatus(), other.previousStatus()) && Objects.equals(this.currentStatus(), other.currentStatus());
    }

    public String toString() {
        return ToString.builder((String)"TerminateConnectionStatus").add("ConnectionId", (Object)this.connectionId()).add("PreviousStatus", (Object)this.previousStatus()).add("CurrentStatus", (Object)this.currentStatus()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConnectionId": {
                return Optional.ofNullable(clazz.cast(this.connectionId()));
            }
            case "PreviousStatus": {
                return Optional.ofNullable(clazz.cast(this.previousStatus()));
            }
            case "CurrentStatus": {
                return Optional.ofNullable(clazz.cast(this.currentStatus()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TerminateConnectionStatus, T> g) {
        return obj -> g.apply((TerminateConnectionStatus)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String connectionId;
        private ClientVpnConnectionStatus previousStatus;
        private ClientVpnConnectionStatus currentStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(TerminateConnectionStatus model) {
            this.connectionId(model.connectionId);
            this.previousStatus(model.previousStatus);
            this.currentStatus(model.currentStatus);
        }

        public final String getConnectionId() {
            return this.connectionId;
        }

        @Override
        public final Builder connectionId(String connectionId) {
            this.connectionId = connectionId;
            return this;
        }

        public final void setConnectionId(String connectionId) {
            this.connectionId = connectionId;
        }

        public final ClientVpnConnectionStatus.Builder getPreviousStatus() {
            return this.previousStatus != null ? this.previousStatus.toBuilder() : null;
        }

        @Override
        public final Builder previousStatus(ClientVpnConnectionStatus previousStatus) {
            this.previousStatus = previousStatus;
            return this;
        }

        public final void setPreviousStatus(ClientVpnConnectionStatus.BuilderImpl previousStatus) {
            this.previousStatus = previousStatus != null ? previousStatus.build() : null;
        }

        public final ClientVpnConnectionStatus.Builder getCurrentStatus() {
            return this.currentStatus != null ? this.currentStatus.toBuilder() : null;
        }

        @Override
        public final Builder currentStatus(ClientVpnConnectionStatus currentStatus) {
            this.currentStatus = currentStatus;
            return this;
        }

        public final void setCurrentStatus(ClientVpnConnectionStatus.BuilderImpl currentStatus) {
            this.currentStatus = currentStatus != null ? currentStatus.build() : null;
        }

        public TerminateConnectionStatus build() {
            return new TerminateConnectionStatus(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TerminateConnectionStatus> {
        public Builder connectionId(String var1);

        public Builder previousStatus(ClientVpnConnectionStatus var1);

        default public Builder previousStatus(Consumer<ClientVpnConnectionStatus.Builder> previousStatus) {
            return this.previousStatus((ClientVpnConnectionStatus)((ClientVpnConnectionStatus.Builder)ClientVpnConnectionStatus.builder().applyMutation(previousStatus)).build());
        }

        public Builder currentStatus(ClientVpnConnectionStatus var1);

        default public Builder currentStatus(Consumer<ClientVpnConnectionStatus.Builder> currentStatus) {
            return this.currentStatus((ClientVpnConnectionStatus)((ClientVpnConnectionStatus.Builder)ClientVpnConnectionStatus.builder().applyMutation(currentStatus)).build());
        }
    }
}

