/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.ValueStringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModifyVpcEndpointServiceConfigurationRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, ModifyVpcEndpointServiceConfigurationRequest> {
    private static final SdkField<String> SERVICE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ModifyVpcEndpointServiceConfigurationRequest.getter(ModifyVpcEndpointServiceConfigurationRequest::serviceId)).setter(ModifyVpcEndpointServiceConfigurationRequest.setter(Builder::serviceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceId").unmarshallLocationName("ServiceId").build()}).build();
    private static final SdkField<Boolean> ACCEPTANCE_REQUIRED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(ModifyVpcEndpointServiceConfigurationRequest.getter(ModifyVpcEndpointServiceConfigurationRequest::acceptanceRequired)).setter(ModifyVpcEndpointServiceConfigurationRequest.setter(Builder::acceptanceRequired)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AcceptanceRequired").unmarshallLocationName("AcceptanceRequired").build()}).build();
    private static final SdkField<List<String>> ADD_NETWORK_LOAD_BALANCER_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ModifyVpcEndpointServiceConfigurationRequest.getter(ModifyVpcEndpointServiceConfigurationRequest::addNetworkLoadBalancerArns)).setter(ModifyVpcEndpointServiceConfigurationRequest.setter(Builder::addNetworkLoadBalancerArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddNetworkLoadBalancerArn").unmarshallLocationName("AddNetworkLoadBalancerArn").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<List<String>> REMOVE_NETWORK_LOAD_BALANCER_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ModifyVpcEndpointServiceConfigurationRequest.getter(ModifyVpcEndpointServiceConfigurationRequest::removeNetworkLoadBalancerArns)).setter(ModifyVpcEndpointServiceConfigurationRequest.setter(Builder::removeNetworkLoadBalancerArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemoveNetworkLoadBalancerArn").unmarshallLocationName("RemoveNetworkLoadBalancerArn").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_ID_FIELD, ACCEPTANCE_REQUIRED_FIELD, ADD_NETWORK_LOAD_BALANCER_ARNS_FIELD, REMOVE_NETWORK_LOAD_BALANCER_ARNS_FIELD));
    private final String serviceId;
    private final Boolean acceptanceRequired;
    private final List<String> addNetworkLoadBalancerArns;
    private final List<String> removeNetworkLoadBalancerArns;

    private ModifyVpcEndpointServiceConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.serviceId = builder.serviceId;
        this.acceptanceRequired = builder.acceptanceRequired;
        this.addNetworkLoadBalancerArns = builder.addNetworkLoadBalancerArns;
        this.removeNetworkLoadBalancerArns = builder.removeNetworkLoadBalancerArns;
    }

    public String serviceId() {
        return this.serviceId;
    }

    public Boolean acceptanceRequired() {
        return this.acceptanceRequired;
    }

    public boolean hasAddNetworkLoadBalancerArns() {
        return this.addNetworkLoadBalancerArns != null && !(this.addNetworkLoadBalancerArns instanceof SdkAutoConstructList);
    }

    public List<String> addNetworkLoadBalancerArns() {
        return this.addNetworkLoadBalancerArns;
    }

    public boolean hasRemoveNetworkLoadBalancerArns() {
        return this.removeNetworkLoadBalancerArns != null && !(this.removeNetworkLoadBalancerArns instanceof SdkAutoConstructList);
    }

    public List<String> removeNetworkLoadBalancerArns() {
        return this.removeNetworkLoadBalancerArns;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.acceptanceRequired());
        hashCode = 31 * hashCode + Objects.hashCode(this.addNetworkLoadBalancerArns());
        hashCode = 31 * hashCode + Objects.hashCode(this.removeNetworkLoadBalancerArns());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyVpcEndpointServiceConfigurationRequest)) {
            return false;
        }
        ModifyVpcEndpointServiceConfigurationRequest other = (ModifyVpcEndpointServiceConfigurationRequest)((Object)obj);
        return Objects.equals(this.serviceId(), other.serviceId()) && Objects.equals(this.acceptanceRequired(), other.acceptanceRequired()) && Objects.equals(this.addNetworkLoadBalancerArns(), other.addNetworkLoadBalancerArns()) && Objects.equals(this.removeNetworkLoadBalancerArns(), other.removeNetworkLoadBalancerArns());
    }

    public String toString() {
        return ToString.builder((String)"ModifyVpcEndpointServiceConfigurationRequest").add("ServiceId", (Object)this.serviceId()).add("AcceptanceRequired", (Object)this.acceptanceRequired()).add("AddNetworkLoadBalancerArns", this.addNetworkLoadBalancerArns()).add("RemoveNetworkLoadBalancerArns", this.removeNetworkLoadBalancerArns()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ServiceId": {
                return Optional.ofNullable(clazz.cast(this.serviceId()));
            }
            case "AcceptanceRequired": {
                return Optional.ofNullable(clazz.cast(this.acceptanceRequired()));
            }
            case "AddNetworkLoadBalancerArns": {
                return Optional.ofNullable(clazz.cast(this.addNetworkLoadBalancerArns()));
            }
            case "RemoveNetworkLoadBalancerArns": {
                return Optional.ofNullable(clazz.cast(this.removeNetworkLoadBalancerArns()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyVpcEndpointServiceConfigurationRequest, T> g) {
        return obj -> g.apply((ModifyVpcEndpointServiceConfigurationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private String serviceId;
        private Boolean acceptanceRequired;
        private List<String> addNetworkLoadBalancerArns = DefaultSdkAutoConstructList.getInstance();
        private List<String> removeNetworkLoadBalancerArns = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyVpcEndpointServiceConfigurationRequest model) {
            super(model);
            this.serviceId(model.serviceId);
            this.acceptanceRequired(model.acceptanceRequired);
            this.addNetworkLoadBalancerArns(model.addNetworkLoadBalancerArns);
            this.removeNetworkLoadBalancerArns(model.removeNetworkLoadBalancerArns);
        }

        public final String getServiceId() {
            return this.serviceId;
        }

        @Override
        public final Builder serviceId(String serviceId) {
            this.serviceId = serviceId;
            return this;
        }

        public final void setServiceId(String serviceId) {
            this.serviceId = serviceId;
        }

        public final Boolean getAcceptanceRequired() {
            return this.acceptanceRequired;
        }

        @Override
        public final Builder acceptanceRequired(Boolean acceptanceRequired) {
            this.acceptanceRequired = acceptanceRequired;
            return this;
        }

        public final void setAcceptanceRequired(Boolean acceptanceRequired) {
            this.acceptanceRequired = acceptanceRequired;
        }

        public final Collection<String> getAddNetworkLoadBalancerArns() {
            return this.addNetworkLoadBalancerArns;
        }

        @Override
        public final Builder addNetworkLoadBalancerArns(Collection<String> addNetworkLoadBalancerArns) {
            this.addNetworkLoadBalancerArns = ValueStringListCopier.copy(addNetworkLoadBalancerArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addNetworkLoadBalancerArns(String ... addNetworkLoadBalancerArns) {
            this.addNetworkLoadBalancerArns(Arrays.asList(addNetworkLoadBalancerArns));
            return this;
        }

        public final void setAddNetworkLoadBalancerArns(Collection<String> addNetworkLoadBalancerArns) {
            this.addNetworkLoadBalancerArns = ValueStringListCopier.copy(addNetworkLoadBalancerArns);
        }

        public final Collection<String> getRemoveNetworkLoadBalancerArns() {
            return this.removeNetworkLoadBalancerArns;
        }

        @Override
        public final Builder removeNetworkLoadBalancerArns(Collection<String> removeNetworkLoadBalancerArns) {
            this.removeNetworkLoadBalancerArns = ValueStringListCopier.copy(removeNetworkLoadBalancerArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder removeNetworkLoadBalancerArns(String ... removeNetworkLoadBalancerArns) {
            this.removeNetworkLoadBalancerArns(Arrays.asList(removeNetworkLoadBalancerArns));
            return this;
        }

        public final void setRemoveNetworkLoadBalancerArns(Collection<String> removeNetworkLoadBalancerArns) {
            this.removeNetworkLoadBalancerArns = ValueStringListCopier.copy(removeNetworkLoadBalancerArns);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyVpcEndpointServiceConfigurationRequest build() {
            return new ModifyVpcEndpointServiceConfigurationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ModifyVpcEndpointServiceConfigurationRequest> {
        public Builder serviceId(String var1);

        public Builder acceptanceRequired(Boolean var1);

        public Builder addNetworkLoadBalancerArns(Collection<String> var1);

        public Builder addNetworkLoadBalancerArns(String ... var1);

        public Builder removeNetworkLoadBalancerArns(Collection<String> var1);

        public Builder removeNetworkLoadBalancerArns(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

