/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.ValueStringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateVpcEndpointServiceConfigurationRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, CreateVpcEndpointServiceConfigurationRequest> {
    private static final SdkField<Boolean> ACCEPTANCE_REQUIRED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(CreateVpcEndpointServiceConfigurationRequest.getter(CreateVpcEndpointServiceConfigurationRequest::acceptanceRequired)).setter(CreateVpcEndpointServiceConfigurationRequest.setter(Builder::acceptanceRequired)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AcceptanceRequired").unmarshallLocationName("AcceptanceRequired").build()}).build();
    private static final SdkField<List<String>> NETWORK_LOAD_BALANCER_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CreateVpcEndpointServiceConfigurationRequest.getter(CreateVpcEndpointServiceConfigurationRequest::networkLoadBalancerArns)).setter(CreateVpcEndpointServiceConfigurationRequest.setter(Builder::networkLoadBalancerArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkLoadBalancerArn").unmarshallLocationName("NetworkLoadBalancerArn").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateVpcEndpointServiceConfigurationRequest.getter(CreateVpcEndpointServiceConfigurationRequest::clientToken)).setter(CreateVpcEndpointServiceConfigurationRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").unmarshallLocationName("ClientToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCEPTANCE_REQUIRED_FIELD, NETWORK_LOAD_BALANCER_ARNS_FIELD, CLIENT_TOKEN_FIELD));
    private final Boolean acceptanceRequired;
    private final List<String> networkLoadBalancerArns;
    private final String clientToken;

    private CreateVpcEndpointServiceConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.acceptanceRequired = builder.acceptanceRequired;
        this.networkLoadBalancerArns = builder.networkLoadBalancerArns;
        this.clientToken = builder.clientToken;
    }

    public Boolean acceptanceRequired() {
        return this.acceptanceRequired;
    }

    public boolean hasNetworkLoadBalancerArns() {
        return this.networkLoadBalancerArns != null && !(this.networkLoadBalancerArns instanceof SdkAutoConstructList);
    }

    public List<String> networkLoadBalancerArns() {
        return this.networkLoadBalancerArns;
    }

    public String clientToken() {
        return this.clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.acceptanceRequired());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkLoadBalancerArns());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateVpcEndpointServiceConfigurationRequest)) {
            return false;
        }
        CreateVpcEndpointServiceConfigurationRequest other = (CreateVpcEndpointServiceConfigurationRequest)((Object)obj);
        return Objects.equals(this.acceptanceRequired(), other.acceptanceRequired()) && Objects.equals(this.networkLoadBalancerArns(), other.networkLoadBalancerArns()) && Objects.equals(this.clientToken(), other.clientToken());
    }

    public String toString() {
        return ToString.builder((String)"CreateVpcEndpointServiceConfigurationRequest").add("AcceptanceRequired", (Object)this.acceptanceRequired()).add("NetworkLoadBalancerArns", this.networkLoadBalancerArns()).add("ClientToken", (Object)this.clientToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AcceptanceRequired": {
                return Optional.ofNullable(clazz.cast(this.acceptanceRequired()));
            }
            case "NetworkLoadBalancerArns": {
                return Optional.ofNullable(clazz.cast(this.networkLoadBalancerArns()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateVpcEndpointServiceConfigurationRequest, T> g) {
        return obj -> g.apply((CreateVpcEndpointServiceConfigurationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private Boolean acceptanceRequired;
        private List<String> networkLoadBalancerArns = DefaultSdkAutoConstructList.getInstance();
        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateVpcEndpointServiceConfigurationRequest model) {
            super(model);
            this.acceptanceRequired(model.acceptanceRequired);
            this.networkLoadBalancerArns(model.networkLoadBalancerArns);
            this.clientToken(model.clientToken);
        }

        public final Boolean getAcceptanceRequired() {
            return this.acceptanceRequired;
        }

        @Override
        public final Builder acceptanceRequired(Boolean acceptanceRequired) {
            this.acceptanceRequired = acceptanceRequired;
            return this;
        }

        public final void setAcceptanceRequired(Boolean acceptanceRequired) {
            this.acceptanceRequired = acceptanceRequired;
        }

        public final Collection<String> getNetworkLoadBalancerArns() {
            return this.networkLoadBalancerArns;
        }

        @Override
        public final Builder networkLoadBalancerArns(Collection<String> networkLoadBalancerArns) {
            this.networkLoadBalancerArns = ValueStringListCopier.copy(networkLoadBalancerArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkLoadBalancerArns(String ... networkLoadBalancerArns) {
            this.networkLoadBalancerArns(Arrays.asList(networkLoadBalancerArns));
            return this;
        }

        public final void setNetworkLoadBalancerArns(Collection<String> networkLoadBalancerArns) {
            this.networkLoadBalancerArns = ValueStringListCopier.copy(networkLoadBalancerArns);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateVpcEndpointServiceConfigurationRequest build() {
            return new CreateVpcEndpointServiceConfigurationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateVpcEndpointServiceConfigurationRequest> {
        public Builder acceptanceRequired(Boolean var1);

        public Builder networkLoadBalancerArns(Collection<String> var1);

        public Builder networkLoadBalancerArns(String ... var1);

        public Builder clientToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

