/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.VolumeStatusItem;
import software.amazon.awssdk.services.ec2.model.VolumeStatusListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeVolumeStatusResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, DescribeVolumeStatusResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeVolumeStatusResponse.getter(DescribeVolumeStatusResponse::nextToken)).setter(DescribeVolumeStatusResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("nextToken").build()}).build();
    private static final SdkField<List<VolumeStatusItem>> VOLUME_STATUSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeVolumeStatusResponse.getter(DescribeVolumeStatusResponse::volumeStatuses)).setter(DescribeVolumeStatusResponse.setter(Builder::volumeStatuses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeStatusSet").unmarshallLocationName("volumeStatusSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(VolumeStatusItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, VOLUME_STATUSES_FIELD));
    private final String nextToken;
    private final List<VolumeStatusItem> volumeStatuses;

    private DescribeVolumeStatusResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.volumeStatuses = builder.volumeStatuses;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public List<VolumeStatusItem> volumeStatuses() {
        return this.volumeStatuses;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.volumeStatuses());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeVolumeStatusResponse)) {
            return false;
        }
        DescribeVolumeStatusResponse other = (DescribeVolumeStatusResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.volumeStatuses(), other.volumeStatuses());
    }

    public String toString() {
        return ToString.builder((String)"DescribeVolumeStatusResponse").add("NextToken", (Object)this.nextToken()).add("VolumeStatuses", this.volumeStatuses()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "VolumeStatuses": {
                return Optional.ofNullable(clazz.cast(this.volumeStatuses()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeVolumeStatusResponse, T> g) {
        return obj -> g.apply((DescribeVolumeStatusResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<VolumeStatusItem> volumeStatuses = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeVolumeStatusResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.volumeStatuses(model.volumeStatuses);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<VolumeStatusItem.Builder> getVolumeStatuses() {
            return this.volumeStatuses != null ? (Collection)this.volumeStatuses.stream().map(VolumeStatusItem::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder volumeStatuses(Collection<VolumeStatusItem> volumeStatuses) {
            this.volumeStatuses = VolumeStatusListCopier.copy(volumeStatuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder volumeStatuses(VolumeStatusItem ... volumeStatuses) {
            this.volumeStatuses(Arrays.asList(volumeStatuses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder volumeStatuses(Consumer<VolumeStatusItem.Builder> ... volumeStatuses) {
            this.volumeStatuses(Stream.of(volumeStatuses).map(c -> (VolumeStatusItem)((VolumeStatusItem.Builder)VolumeStatusItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setVolumeStatuses(Collection<VolumeStatusItem.BuilderImpl> volumeStatuses) {
            this.volumeStatuses = VolumeStatusListCopier.copyFromBuilder(volumeStatuses);
        }

        @Override
        public DescribeVolumeStatusResponse build() {
            return new DescribeVolumeStatusResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeVolumeStatusResponse> {
        public Builder nextToken(String var1);

        public Builder volumeStatuses(Collection<VolumeStatusItem> var1);

        public Builder volumeStatuses(VolumeStatusItem ... var1);

        public Builder volumeStatuses(Consumer<VolumeStatusItem.Builder> ... var1);
    }
}

