/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.AssignedPrivateIpAddress;
import software.amazon.awssdk.services.ec2.model.AssignedPrivateIpAddressListCopier;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssignPrivateIpAddressesResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, AssignPrivateIpAddressesResponse> {
    private static final SdkField<String> NETWORK_INTERFACE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AssignPrivateIpAddressesResponse.getter(AssignPrivateIpAddressesResponse::networkInterfaceId)).setter(AssignPrivateIpAddressesResponse.setter(Builder::networkInterfaceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInterfaceId").unmarshallLocationName("networkInterfaceId").build()}).build();
    private static final SdkField<List<AssignedPrivateIpAddress>> ASSIGNED_PRIVATE_IP_ADDRESSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(AssignPrivateIpAddressesResponse.getter(AssignPrivateIpAddressesResponse::assignedPrivateIpAddresses)).setter(AssignPrivateIpAddressesResponse.setter(Builder::assignedPrivateIpAddresses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssignedPrivateIpAddressesSet").unmarshallLocationName("assignedPrivateIpAddressesSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AssignedPrivateIpAddress::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NETWORK_INTERFACE_ID_FIELD, ASSIGNED_PRIVATE_IP_ADDRESSES_FIELD));
    private final String networkInterfaceId;
    private final List<AssignedPrivateIpAddress> assignedPrivateIpAddresses;

    private AssignPrivateIpAddressesResponse(BuilderImpl builder) {
        super(builder);
        this.networkInterfaceId = builder.networkInterfaceId;
        this.assignedPrivateIpAddresses = builder.assignedPrivateIpAddresses;
    }

    public String networkInterfaceId() {
        return this.networkInterfaceId;
    }

    public boolean hasAssignedPrivateIpAddresses() {
        return this.assignedPrivateIpAddresses != null && !(this.assignedPrivateIpAddresses instanceof SdkAutoConstructList);
    }

    public List<AssignedPrivateIpAddress> assignedPrivateIpAddresses() {
        return this.assignedPrivateIpAddresses;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.networkInterfaceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.assignedPrivateIpAddresses());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssignPrivateIpAddressesResponse)) {
            return false;
        }
        AssignPrivateIpAddressesResponse other = (AssignPrivateIpAddressesResponse)((Object)obj);
        return Objects.equals(this.networkInterfaceId(), other.networkInterfaceId()) && Objects.equals(this.assignedPrivateIpAddresses(), other.assignedPrivateIpAddresses());
    }

    public String toString() {
        return ToString.builder((String)"AssignPrivateIpAddressesResponse").add("NetworkInterfaceId", (Object)this.networkInterfaceId()).add("AssignedPrivateIpAddresses", this.assignedPrivateIpAddresses()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NetworkInterfaceId": {
                return Optional.ofNullable(clazz.cast(this.networkInterfaceId()));
            }
            case "AssignedPrivateIpAddresses": {
                return Optional.ofNullable(clazz.cast(this.assignedPrivateIpAddresses()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssignPrivateIpAddressesResponse, T> g) {
        return obj -> g.apply((AssignPrivateIpAddressesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private String networkInterfaceId;
        private List<AssignedPrivateIpAddress> assignedPrivateIpAddresses = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AssignPrivateIpAddressesResponse model) {
            super(model);
            this.networkInterfaceId(model.networkInterfaceId);
            this.assignedPrivateIpAddresses(model.assignedPrivateIpAddresses);
        }

        public final String getNetworkInterfaceId() {
            return this.networkInterfaceId;
        }

        @Override
        public final Builder networkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
            return this;
        }

        public final void setNetworkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
        }

        public final Collection<AssignedPrivateIpAddress.Builder> getAssignedPrivateIpAddresses() {
            return this.assignedPrivateIpAddresses != null ? (Collection)this.assignedPrivateIpAddresses.stream().map(AssignedPrivateIpAddress::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder assignedPrivateIpAddresses(Collection<AssignedPrivateIpAddress> assignedPrivateIpAddresses) {
            this.assignedPrivateIpAddresses = AssignedPrivateIpAddressListCopier.copy(assignedPrivateIpAddresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assignedPrivateIpAddresses(AssignedPrivateIpAddress ... assignedPrivateIpAddresses) {
            this.assignedPrivateIpAddresses(Arrays.asList(assignedPrivateIpAddresses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assignedPrivateIpAddresses(Consumer<AssignedPrivateIpAddress.Builder> ... assignedPrivateIpAddresses) {
            this.assignedPrivateIpAddresses(Stream.of(assignedPrivateIpAddresses).map(c -> (AssignedPrivateIpAddress)((AssignedPrivateIpAddress.Builder)AssignedPrivateIpAddress.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAssignedPrivateIpAddresses(Collection<AssignedPrivateIpAddress.BuilderImpl> assignedPrivateIpAddresses) {
            this.assignedPrivateIpAddresses = AssignedPrivateIpAddressListCopier.copyFromBuilder(assignedPrivateIpAddresses);
        }

        @Override
        public AssignPrivateIpAddressesResponse build() {
            return new AssignPrivateIpAddressesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AssignPrivateIpAddressesResponse> {
        public Builder networkInterfaceId(String var1);

        public Builder assignedPrivateIpAddresses(Collection<AssignedPrivateIpAddress> var1);

        public Builder assignedPrivateIpAddresses(AssignedPrivateIpAddress ... var1);

        public Builder assignedPrivateIpAddresses(Consumer<AssignedPrivateIpAddress.Builder> ... var1);
    }
}

