/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.TransitGatewayAssociation;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DisassociateTransitGatewayRouteTableResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, DisassociateTransitGatewayRouteTableResponse> {
    private static final SdkField<TransitGatewayAssociation> ASSOCIATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(DisassociateTransitGatewayRouteTableResponse.getter(DisassociateTransitGatewayRouteTableResponse::association)).setter(DisassociateTransitGatewayRouteTableResponse.setter(Builder::association)).constructor(TransitGatewayAssociation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Association").unmarshallLocationName("association").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSOCIATION_FIELD));
    private final TransitGatewayAssociation association;

    private DisassociateTransitGatewayRouteTableResponse(BuilderImpl builder) {
        super(builder);
        this.association = builder.association;
    }

    public TransitGatewayAssociation association() {
        return this.association;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.association());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DisassociateTransitGatewayRouteTableResponse)) {
            return false;
        }
        DisassociateTransitGatewayRouteTableResponse other = (DisassociateTransitGatewayRouteTableResponse)((Object)obj);
        return Objects.equals(this.association(), other.association());
    }

    public String toString() {
        return ToString.builder((String)"DisassociateTransitGatewayRouteTableResponse").add("Association", (Object)this.association()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Association": {
                return Optional.ofNullable(clazz.cast(this.association()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DisassociateTransitGatewayRouteTableResponse, T> g) {
        return obj -> g.apply((DisassociateTransitGatewayRouteTableResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private TransitGatewayAssociation association;

        private BuilderImpl() {
        }

        private BuilderImpl(DisassociateTransitGatewayRouteTableResponse model) {
            super(model);
            this.association(model.association);
        }

        public final TransitGatewayAssociation.Builder getAssociation() {
            return this.association != null ? this.association.toBuilder() : null;
        }

        @Override
        public final Builder association(TransitGatewayAssociation association) {
            this.association = association;
            return this;
        }

        public final void setAssociation(TransitGatewayAssociation.BuilderImpl association) {
            this.association = association != null ? association.build() : null;
        }

        @Override
        public DisassociateTransitGatewayRouteTableResponse build() {
            return new DisassociateTransitGatewayRouteTableResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DisassociateTransitGatewayRouteTableResponse> {
        public Builder association(TransitGatewayAssociation var1);

        default public Builder association(Consumer<TransitGatewayAssociation.Builder> association) {
            return this.association((TransitGatewayAssociation)((TransitGatewayAssociation.Builder)TransitGatewayAssociation.builder().applyMutation(association)).build());
        }
    }
}

