/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.TunnelOption;
import software.amazon.awssdk.services.ec2.model.TunnelOptionsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VpnConnectionOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, VpnConnectionOptions> {
    private static final SdkField<Boolean> ENABLE_ACCELERATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(VpnConnectionOptions.getter(VpnConnectionOptions::enableAcceleration)).setter(VpnConnectionOptions.setter(Builder::enableAcceleration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableAcceleration").unmarshallLocationName("enableAcceleration").build()}).build();
    private static final SdkField<Boolean> STATIC_ROUTES_ONLY_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(VpnConnectionOptions.getter(VpnConnectionOptions::staticRoutesOnly)).setter(VpnConnectionOptions.setter(Builder::staticRoutesOnly)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StaticRoutesOnly").unmarshallLocationName("staticRoutesOnly").build()}).build();
    private static final SdkField<List<TunnelOption>> TUNNEL_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(VpnConnectionOptions.getter(VpnConnectionOptions::tunnelOptions)).setter(VpnConnectionOptions.setter(Builder::tunnelOptions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TunnelOptionSet").unmarshallLocationName("tunnelOptionSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TunnelOption::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENABLE_ACCELERATION_FIELD, STATIC_ROUTES_ONLY_FIELD, TUNNEL_OPTIONS_FIELD));
    private static final long serialVersionUID = 1L;
    private final Boolean enableAcceleration;
    private final Boolean staticRoutesOnly;
    private final List<TunnelOption> tunnelOptions;

    private VpnConnectionOptions(BuilderImpl builder) {
        this.enableAcceleration = builder.enableAcceleration;
        this.staticRoutesOnly = builder.staticRoutesOnly;
        this.tunnelOptions = builder.tunnelOptions;
    }

    public Boolean enableAcceleration() {
        return this.enableAcceleration;
    }

    public Boolean staticRoutesOnly() {
        return this.staticRoutesOnly;
    }

    public List<TunnelOption> tunnelOptions() {
        return this.tunnelOptions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.enableAcceleration());
        hashCode = 31 * hashCode + Objects.hashCode(this.staticRoutesOnly());
        hashCode = 31 * hashCode + Objects.hashCode(this.tunnelOptions());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VpnConnectionOptions)) {
            return false;
        }
        VpnConnectionOptions other = (VpnConnectionOptions)obj;
        return Objects.equals(this.enableAcceleration(), other.enableAcceleration()) && Objects.equals(this.staticRoutesOnly(), other.staticRoutesOnly()) && Objects.equals(this.tunnelOptions(), other.tunnelOptions());
    }

    public String toString() {
        return ToString.builder((String)"VpnConnectionOptions").add("EnableAcceleration", (Object)this.enableAcceleration()).add("StaticRoutesOnly", (Object)this.staticRoutesOnly()).add("TunnelOptions", this.tunnelOptions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EnableAcceleration": {
                return Optional.ofNullable(clazz.cast(this.enableAcceleration()));
            }
            case "StaticRoutesOnly": {
                return Optional.ofNullable(clazz.cast(this.staticRoutesOnly()));
            }
            case "TunnelOptions": {
                return Optional.ofNullable(clazz.cast(this.tunnelOptions()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VpnConnectionOptions, T> g) {
        return obj -> g.apply((VpnConnectionOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean enableAcceleration;
        private Boolean staticRoutesOnly;
        private List<TunnelOption> tunnelOptions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(VpnConnectionOptions model) {
            this.enableAcceleration(model.enableAcceleration);
            this.staticRoutesOnly(model.staticRoutesOnly);
            this.tunnelOptions(model.tunnelOptions);
        }

        public final Boolean getEnableAcceleration() {
            return this.enableAcceleration;
        }

        @Override
        public final Builder enableAcceleration(Boolean enableAcceleration) {
            this.enableAcceleration = enableAcceleration;
            return this;
        }

        public final void setEnableAcceleration(Boolean enableAcceleration) {
            this.enableAcceleration = enableAcceleration;
        }

        public final Boolean getStaticRoutesOnly() {
            return this.staticRoutesOnly;
        }

        @Override
        public final Builder staticRoutesOnly(Boolean staticRoutesOnly) {
            this.staticRoutesOnly = staticRoutesOnly;
            return this;
        }

        public final void setStaticRoutesOnly(Boolean staticRoutesOnly) {
            this.staticRoutesOnly = staticRoutesOnly;
        }

        public final Collection<TunnelOption.Builder> getTunnelOptions() {
            return this.tunnelOptions != null ? (Collection)this.tunnelOptions.stream().map(TunnelOption::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tunnelOptions(Collection<TunnelOption> tunnelOptions) {
            this.tunnelOptions = TunnelOptionsListCopier.copy(tunnelOptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tunnelOptions(TunnelOption ... tunnelOptions) {
            this.tunnelOptions(Arrays.asList(tunnelOptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tunnelOptions(Consumer<TunnelOption.Builder> ... tunnelOptions) {
            this.tunnelOptions(Stream.of(tunnelOptions).map(c -> (TunnelOption)((TunnelOption.Builder)TunnelOption.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTunnelOptions(Collection<TunnelOption.BuilderImpl> tunnelOptions) {
            this.tunnelOptions = TunnelOptionsListCopier.copyFromBuilder(tunnelOptions);
        }

        public VpnConnectionOptions build() {
            return new VpnConnectionOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, VpnConnectionOptions> {
        public Builder enableAcceleration(Boolean var1);

        public Builder staticRoutesOnly(Boolean var1);

        public Builder tunnelOptions(Collection<TunnelOption> var1);

        public Builder tunnelOptions(TunnelOption ... var1);

        public Builder tunnelOptions(Consumer<TunnelOption.Builder> ... var1);
    }
}

