/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.AttributeValue;
import software.amazon.awssdk.services.ec2.model.BlockDeviceMapping;
import software.amazon.awssdk.services.ec2.model.BlockDeviceMappingListCopier;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.LaunchPermission;
import software.amazon.awssdk.services.ec2.model.LaunchPermissionListCopier;
import software.amazon.awssdk.services.ec2.model.ProductCode;
import software.amazon.awssdk.services.ec2.model.ProductCodeListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeImageAttributeResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, DescribeImageAttributeResponse> {
    private static final SdkField<List<BlockDeviceMapping>> BLOCK_DEVICE_MAPPINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeImageAttributeResponse.getter(DescribeImageAttributeResponse::blockDeviceMappings)).setter(DescribeImageAttributeResponse.setter(Builder::blockDeviceMappings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BlockDeviceMapping").unmarshallLocationName("blockDeviceMapping").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BlockDeviceMapping::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> IMAGE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeImageAttributeResponse.getter(DescribeImageAttributeResponse::imageId)).setter(DescribeImageAttributeResponse.setter(Builder::imageId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageId").unmarshallLocationName("imageId").build()}).build();
    private static final SdkField<List<LaunchPermission>> LAUNCH_PERMISSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeImageAttributeResponse.getter(DescribeImageAttributeResponse::launchPermissions)).setter(DescribeImageAttributeResponse.setter(Builder::launchPermissions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchPermission").unmarshallLocationName("launchPermission").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LaunchPermission::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<List<ProductCode>> PRODUCT_CODES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeImageAttributeResponse.getter(DescribeImageAttributeResponse::productCodes)).setter(DescribeImageAttributeResponse.setter(Builder::productCodes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductCodes").unmarshallLocationName("productCodes").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ProductCode::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<AttributeValue> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(DescribeImageAttributeResponse.getter(DescribeImageAttributeResponse::description)).setter(DescribeImageAttributeResponse.setter(Builder::description)).constructor(AttributeValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").unmarshallLocationName("description").build()}).build();
    private static final SdkField<AttributeValue> KERNEL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(DescribeImageAttributeResponse.getter(DescribeImageAttributeResponse::kernelId)).setter(DescribeImageAttributeResponse.setter(Builder::kernelId)).constructor(AttributeValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Kernel").unmarshallLocationName("kernel").build()}).build();
    private static final SdkField<AttributeValue> RAMDISK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(DescribeImageAttributeResponse.getter(DescribeImageAttributeResponse::ramdiskId)).setter(DescribeImageAttributeResponse.setter(Builder::ramdiskId)).constructor(AttributeValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ramdisk").unmarshallLocationName("ramdisk").build()}).build();
    private static final SdkField<AttributeValue> SRIOV_NET_SUPPORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(DescribeImageAttributeResponse.getter(DescribeImageAttributeResponse::sriovNetSupport)).setter(DescribeImageAttributeResponse.setter(Builder::sriovNetSupport)).constructor(AttributeValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SriovNetSupport").unmarshallLocationName("sriovNetSupport").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BLOCK_DEVICE_MAPPINGS_FIELD, IMAGE_ID_FIELD, LAUNCH_PERMISSIONS_FIELD, PRODUCT_CODES_FIELD, DESCRIPTION_FIELD, KERNEL_ID_FIELD, RAMDISK_ID_FIELD, SRIOV_NET_SUPPORT_FIELD));
    private final List<BlockDeviceMapping> blockDeviceMappings;
    private final String imageId;
    private final List<LaunchPermission> launchPermissions;
    private final List<ProductCode> productCodes;
    private final AttributeValue description;
    private final AttributeValue kernelId;
    private final AttributeValue ramdiskId;
    private final AttributeValue sriovNetSupport;

    private DescribeImageAttributeResponse(BuilderImpl builder) {
        super(builder);
        this.blockDeviceMappings = builder.blockDeviceMappings;
        this.imageId = builder.imageId;
        this.launchPermissions = builder.launchPermissions;
        this.productCodes = builder.productCodes;
        this.description = builder.description;
        this.kernelId = builder.kernelId;
        this.ramdiskId = builder.ramdiskId;
        this.sriovNetSupport = builder.sriovNetSupport;
    }

    public List<BlockDeviceMapping> blockDeviceMappings() {
        return this.blockDeviceMappings;
    }

    public String imageId() {
        return this.imageId;
    }

    public List<LaunchPermission> launchPermissions() {
        return this.launchPermissions;
    }

    public List<ProductCode> productCodes() {
        return this.productCodes;
    }

    public AttributeValue description() {
        return this.description;
    }

    public AttributeValue kernelId() {
        return this.kernelId;
    }

    public AttributeValue ramdiskId() {
        return this.ramdiskId;
    }

    public AttributeValue sriovNetSupport() {
        return this.sriovNetSupport;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.blockDeviceMappings());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageId());
        hashCode = 31 * hashCode + Objects.hashCode(this.launchPermissions());
        hashCode = 31 * hashCode + Objects.hashCode(this.productCodes());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.kernelId());
        hashCode = 31 * hashCode + Objects.hashCode(this.ramdiskId());
        hashCode = 31 * hashCode + Objects.hashCode(this.sriovNetSupport());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeImageAttributeResponse)) {
            return false;
        }
        DescribeImageAttributeResponse other = (DescribeImageAttributeResponse)((Object)obj);
        return Objects.equals(this.blockDeviceMappings(), other.blockDeviceMappings()) && Objects.equals(this.imageId(), other.imageId()) && Objects.equals(this.launchPermissions(), other.launchPermissions()) && Objects.equals(this.productCodes(), other.productCodes()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.kernelId(), other.kernelId()) && Objects.equals(this.ramdiskId(), other.ramdiskId()) && Objects.equals(this.sriovNetSupport(), other.sriovNetSupport());
    }

    public String toString() {
        return ToString.builder((String)"DescribeImageAttributeResponse").add("BlockDeviceMappings", this.blockDeviceMappings()).add("ImageId", (Object)this.imageId()).add("LaunchPermissions", this.launchPermissions()).add("ProductCodes", this.productCodes()).add("Description", (Object)this.description()).add("KernelId", (Object)this.kernelId()).add("RamdiskId", (Object)this.ramdiskId()).add("SriovNetSupport", (Object)this.sriovNetSupport()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BlockDeviceMappings": {
                return Optional.ofNullable(clazz.cast(this.blockDeviceMappings()));
            }
            case "ImageId": {
                return Optional.ofNullable(clazz.cast(this.imageId()));
            }
            case "LaunchPermissions": {
                return Optional.ofNullable(clazz.cast(this.launchPermissions()));
            }
            case "ProductCodes": {
                return Optional.ofNullable(clazz.cast(this.productCodes()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "KernelId": {
                return Optional.ofNullable(clazz.cast(this.kernelId()));
            }
            case "RamdiskId": {
                return Optional.ofNullable(clazz.cast(this.ramdiskId()));
            }
            case "SriovNetSupport": {
                return Optional.ofNullable(clazz.cast(this.sriovNetSupport()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeImageAttributeResponse, T> g) {
        return obj -> g.apply((DescribeImageAttributeResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<BlockDeviceMapping> blockDeviceMappings = DefaultSdkAutoConstructList.getInstance();
        private String imageId;
        private List<LaunchPermission> launchPermissions = DefaultSdkAutoConstructList.getInstance();
        private List<ProductCode> productCodes = DefaultSdkAutoConstructList.getInstance();
        private AttributeValue description;
        private AttributeValue kernelId;
        private AttributeValue ramdiskId;
        private AttributeValue sriovNetSupport;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeImageAttributeResponse model) {
            super(model);
            this.blockDeviceMappings(model.blockDeviceMappings);
            this.imageId(model.imageId);
            this.launchPermissions(model.launchPermissions);
            this.productCodes(model.productCodes);
            this.description(model.description);
            this.kernelId(model.kernelId);
            this.ramdiskId(model.ramdiskId);
            this.sriovNetSupport(model.sriovNetSupport);
        }

        public final Collection<BlockDeviceMapping.Builder> getBlockDeviceMappings() {
            return this.blockDeviceMappings != null ? (Collection)this.blockDeviceMappings.stream().map(BlockDeviceMapping::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder blockDeviceMappings(Collection<BlockDeviceMapping> blockDeviceMappings) {
            this.blockDeviceMappings = BlockDeviceMappingListCopier.copy(blockDeviceMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockDeviceMappings(BlockDeviceMapping ... blockDeviceMappings) {
            this.blockDeviceMappings(Arrays.asList(blockDeviceMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockDeviceMappings(Consumer<BlockDeviceMapping.Builder> ... blockDeviceMappings) {
            this.blockDeviceMappings(Stream.of(blockDeviceMappings).map(c -> (BlockDeviceMapping)((BlockDeviceMapping.Builder)BlockDeviceMapping.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setBlockDeviceMappings(Collection<BlockDeviceMapping.BuilderImpl> blockDeviceMappings) {
            this.blockDeviceMappings = BlockDeviceMappingListCopier.copyFromBuilder(blockDeviceMappings);
        }

        public final String getImageId() {
            return this.imageId;
        }

        @Override
        public final Builder imageId(String imageId) {
            this.imageId = imageId;
            return this;
        }

        public final void setImageId(String imageId) {
            this.imageId = imageId;
        }

        public final Collection<LaunchPermission.Builder> getLaunchPermissions() {
            return this.launchPermissions != null ? (Collection)this.launchPermissions.stream().map(LaunchPermission::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder launchPermissions(Collection<LaunchPermission> launchPermissions) {
            this.launchPermissions = LaunchPermissionListCopier.copy(launchPermissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder launchPermissions(LaunchPermission ... launchPermissions) {
            this.launchPermissions(Arrays.asList(launchPermissions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder launchPermissions(Consumer<LaunchPermission.Builder> ... launchPermissions) {
            this.launchPermissions(Stream.of(launchPermissions).map(c -> (LaunchPermission)((LaunchPermission.Builder)LaunchPermission.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setLaunchPermissions(Collection<LaunchPermission.BuilderImpl> launchPermissions) {
            this.launchPermissions = LaunchPermissionListCopier.copyFromBuilder(launchPermissions);
        }

        public final Collection<ProductCode.Builder> getProductCodes() {
            return this.productCodes != null ? (Collection)this.productCodes.stream().map(ProductCode::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder productCodes(Collection<ProductCode> productCodes) {
            this.productCodes = ProductCodeListCopier.copy(productCodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder productCodes(ProductCode ... productCodes) {
            this.productCodes(Arrays.asList(productCodes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder productCodes(Consumer<ProductCode.Builder> ... productCodes) {
            this.productCodes(Stream.of(productCodes).map(c -> (ProductCode)((ProductCode.Builder)ProductCode.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setProductCodes(Collection<ProductCode.BuilderImpl> productCodes) {
            this.productCodes = ProductCodeListCopier.copyFromBuilder(productCodes);
        }

        public final AttributeValue.Builder getDescription() {
            return this.description != null ? this.description.toBuilder() : null;
        }

        @Override
        public final Builder description(AttributeValue description) {
            this.description = description;
            return this;
        }

        public final void setDescription(AttributeValue.BuilderImpl description) {
            this.description = description != null ? description.build() : null;
        }

        public final AttributeValue.Builder getKernelId() {
            return this.kernelId != null ? this.kernelId.toBuilder() : null;
        }

        @Override
        public final Builder kernelId(AttributeValue kernelId) {
            this.kernelId = kernelId;
            return this;
        }

        public final void setKernelId(AttributeValue.BuilderImpl kernelId) {
            this.kernelId = kernelId != null ? kernelId.build() : null;
        }

        public final AttributeValue.Builder getRamdiskId() {
            return this.ramdiskId != null ? this.ramdiskId.toBuilder() : null;
        }

        @Override
        public final Builder ramdiskId(AttributeValue ramdiskId) {
            this.ramdiskId = ramdiskId;
            return this;
        }

        public final void setRamdiskId(AttributeValue.BuilderImpl ramdiskId) {
            this.ramdiskId = ramdiskId != null ? ramdiskId.build() : null;
        }

        public final AttributeValue.Builder getSriovNetSupport() {
            return this.sriovNetSupport != null ? this.sriovNetSupport.toBuilder() : null;
        }

        @Override
        public final Builder sriovNetSupport(AttributeValue sriovNetSupport) {
            this.sriovNetSupport = sriovNetSupport;
            return this;
        }

        public final void setSriovNetSupport(AttributeValue.BuilderImpl sriovNetSupport) {
            this.sriovNetSupport = sriovNetSupport != null ? sriovNetSupport.build() : null;
        }

        @Override
        public DescribeImageAttributeResponse build() {
            return new DescribeImageAttributeResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeImageAttributeResponse> {
        public Builder blockDeviceMappings(Collection<BlockDeviceMapping> var1);

        public Builder blockDeviceMappings(BlockDeviceMapping ... var1);

        public Builder blockDeviceMappings(Consumer<BlockDeviceMapping.Builder> ... var1);

        public Builder imageId(String var1);

        public Builder launchPermissions(Collection<LaunchPermission> var1);

        public Builder launchPermissions(LaunchPermission ... var1);

        public Builder launchPermissions(Consumer<LaunchPermission.Builder> ... var1);

        public Builder productCodes(Collection<ProductCode> var1);

        public Builder productCodes(ProductCode ... var1);

        public Builder productCodes(Consumer<ProductCode.Builder> ... var1);

        public Builder description(AttributeValue var1);

        default public Builder description(Consumer<AttributeValue.Builder> description) {
            return this.description((AttributeValue)((AttributeValue.Builder)AttributeValue.builder().applyMutation(description)).build());
        }

        public Builder kernelId(AttributeValue var1);

        default public Builder kernelId(Consumer<AttributeValue.Builder> kernelId) {
            return this.kernelId((AttributeValue)((AttributeValue.Builder)AttributeValue.builder().applyMutation(kernelId)).build());
        }

        public Builder ramdiskId(AttributeValue var1);

        default public Builder ramdiskId(Consumer<AttributeValue.Builder> ramdiskId) {
            return this.ramdiskId((AttributeValue)((AttributeValue.Builder)AttributeValue.builder().applyMutation(ramdiskId)).build());
        }

        public Builder sriovNetSupport(AttributeValue var1);

        default public Builder sriovNetSupport(Consumer<AttributeValue.Builder> sriovNetSupport) {
            return this.sriovNetSupport((AttributeValue)((AttributeValue.Builder)AttributeValue.builder().applyMutation(sriovNetSupport)).build());
        }
    }
}

