/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CustomerGateway
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CustomerGateway> {
    private static final SdkField<String> BGP_ASN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CustomerGateway.getter(CustomerGateway::bgpAsn)).setter(CustomerGateway.setter(Builder::bgpAsn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BgpAsn").unmarshallLocationName("bgpAsn").build()}).build();
    private static final SdkField<String> CUSTOMER_GATEWAY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CustomerGateway.getter(CustomerGateway::customerGatewayId)).setter(CustomerGateway.setter(Builder::customerGatewayId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomerGatewayId").unmarshallLocationName("customerGatewayId").build()}).build();
    private static final SdkField<String> IP_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CustomerGateway.getter(CustomerGateway::ipAddress)).setter(CustomerGateway.setter(Builder::ipAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpAddress").unmarshallLocationName("ipAddress").build()}).build();
    private static final SdkField<String> CERTIFICATE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CustomerGateway.getter(CustomerGateway::certificateArn)).setter(CustomerGateway.setter(Builder::certificateArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateArn").unmarshallLocationName("certificateArn").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CustomerGateway.getter(CustomerGateway::state)).setter(CustomerGateway.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").unmarshallLocationName("state").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CustomerGateway.getter(CustomerGateway::type)).setter(CustomerGateway.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").unmarshallLocationName("type").build()}).build();
    private static final SdkField<String> DEVICE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CustomerGateway.getter(CustomerGateway::deviceName)).setter(CustomerGateway.setter(Builder::deviceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceName").unmarshallLocationName("deviceName").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CustomerGateway.getter(CustomerGateway::tags)).setter(CustomerGateway.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet").unmarshallLocationName("tagSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BGP_ASN_FIELD, CUSTOMER_GATEWAY_ID_FIELD, IP_ADDRESS_FIELD, CERTIFICATE_ARN_FIELD, STATE_FIELD, TYPE_FIELD, DEVICE_NAME_FIELD, TAGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String bgpAsn;
    private final String customerGatewayId;
    private final String ipAddress;
    private final String certificateArn;
    private final String state;
    private final String type;
    private final String deviceName;
    private final List<Tag> tags;

    private CustomerGateway(BuilderImpl builder) {
        this.bgpAsn = builder.bgpAsn;
        this.customerGatewayId = builder.customerGatewayId;
        this.ipAddress = builder.ipAddress;
        this.certificateArn = builder.certificateArn;
        this.state = builder.state;
        this.type = builder.type;
        this.deviceName = builder.deviceName;
        this.tags = builder.tags;
    }

    public String bgpAsn() {
        return this.bgpAsn;
    }

    public String customerGatewayId() {
        return this.customerGatewayId;
    }

    public String ipAddress() {
        return this.ipAddress;
    }

    public String certificateArn() {
        return this.certificateArn;
    }

    public String state() {
        return this.state;
    }

    public String type() {
        return this.type;
    }

    public String deviceName() {
        return this.deviceName;
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.bgpAsn());
        hashCode = 31 * hashCode + Objects.hashCode(this.customerGatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.state());
        hashCode = 31 * hashCode + Objects.hashCode(this.type());
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomerGateway)) {
            return false;
        }
        CustomerGateway other = (CustomerGateway)obj;
        return Objects.equals(this.bgpAsn(), other.bgpAsn()) && Objects.equals(this.customerGatewayId(), other.customerGatewayId()) && Objects.equals(this.ipAddress(), other.ipAddress()) && Objects.equals(this.certificateArn(), other.certificateArn()) && Objects.equals(this.state(), other.state()) && Objects.equals(this.type(), other.type()) && Objects.equals(this.deviceName(), other.deviceName()) && Objects.equals(this.tags(), other.tags());
    }

    public String toString() {
        return ToString.builder((String)"CustomerGateway").add("BgpAsn", (Object)this.bgpAsn()).add("CustomerGatewayId", (Object)this.customerGatewayId()).add("IpAddress", (Object)this.ipAddress()).add("CertificateArn", (Object)this.certificateArn()).add("State", (Object)this.state()).add("Type", (Object)this.type()).add("DeviceName", (Object)this.deviceName()).add("Tags", this.tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BgpAsn": {
                return Optional.ofNullable(clazz.cast(this.bgpAsn()));
            }
            case "CustomerGatewayId": {
                return Optional.ofNullable(clazz.cast(this.customerGatewayId()));
            }
            case "IpAddress": {
                return Optional.ofNullable(clazz.cast(this.ipAddress()));
            }
            case "CertificateArn": {
                return Optional.ofNullable(clazz.cast(this.certificateArn()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.state()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.type()));
            }
            case "DeviceName": {
                return Optional.ofNullable(clazz.cast(this.deviceName()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CustomerGateway, T> g) {
        return obj -> g.apply((CustomerGateway)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String bgpAsn;
        private String customerGatewayId;
        private String ipAddress;
        private String certificateArn;
        private String state;
        private String type;
        private String deviceName;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CustomerGateway model) {
            this.bgpAsn(model.bgpAsn);
            this.customerGatewayId(model.customerGatewayId);
            this.ipAddress(model.ipAddress);
            this.certificateArn(model.certificateArn);
            this.state(model.state);
            this.type(model.type);
            this.deviceName(model.deviceName);
            this.tags(model.tags);
        }

        public final String getBgpAsn() {
            return this.bgpAsn;
        }

        @Override
        public final Builder bgpAsn(String bgpAsn) {
            this.bgpAsn = bgpAsn;
            return this;
        }

        public final void setBgpAsn(String bgpAsn) {
            this.bgpAsn = bgpAsn;
        }

        public final String getCustomerGatewayId() {
            return this.customerGatewayId;
        }

        @Override
        public final Builder customerGatewayId(String customerGatewayId) {
            this.customerGatewayId = customerGatewayId;
            return this;
        }

        public final void setCustomerGatewayId(String customerGatewayId) {
            this.customerGatewayId = customerGatewayId;
        }

        public final String getIpAddress() {
            return this.ipAddress;
        }

        @Override
        public final Builder ipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        public final void setIpAddress(String ipAddress) {
            this.ipAddress = ipAddress;
        }

        public final String getCertificateArn() {
            return this.certificateArn;
        }

        @Override
        public final Builder certificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
            return this;
        }

        public final void setCertificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getDeviceName() {
            return this.deviceName;
        }

        @Override
        public final Builder deviceName(String deviceName) {
            this.deviceName = deviceName;
            return this;
        }

        public final void setDeviceName(String deviceName) {
            this.deviceName = deviceName;
        }

        public final Collection<Tag.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public CustomerGateway build() {
            return new CustomerGateway(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CustomerGateway> {
        public Builder bgpAsn(String var1);

        public Builder customerGatewayId(String var1);

        public Builder ipAddress(String var1);

        public Builder certificateArn(String var1);

        public Builder state(String var1);

        public Builder type(String var1);

        public Builder deviceName(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);
    }
}

