/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.SnapshotDetail;
import software.amazon.awssdk.services.ec2.model.SnapshotDetailListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ImportImageResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, ImportImageResponse> {
    private static final SdkField<String> ARCHITECTURE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ImportImageResponse.getter(ImportImageResponse::architecture)).setter(ImportImageResponse.setter(Builder::architecture)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Architecture").unmarshallLocationName("architecture").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ImportImageResponse.getter(ImportImageResponse::description)).setter(ImportImageResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").unmarshallLocationName("description").build()}).build();
    private static final SdkField<Boolean> ENCRYPTED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(ImportImageResponse.getter(ImportImageResponse::encrypted)).setter(ImportImageResponse.setter(Builder::encrypted)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Encrypted").unmarshallLocationName("encrypted").build()}).build();
    private static final SdkField<String> HYPERVISOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ImportImageResponse.getter(ImportImageResponse::hypervisor)).setter(ImportImageResponse.setter(Builder::hypervisor)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Hypervisor").unmarshallLocationName("hypervisor").build()}).build();
    private static final SdkField<String> IMAGE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ImportImageResponse.getter(ImportImageResponse::imageId)).setter(ImportImageResponse.setter(Builder::imageId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageId").unmarshallLocationName("imageId").build()}).build();
    private static final SdkField<String> IMPORT_TASK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ImportImageResponse.getter(ImportImageResponse::importTaskId)).setter(ImportImageResponse.setter(Builder::importTaskId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImportTaskId").unmarshallLocationName("importTaskId").build()}).build();
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ImportImageResponse.getter(ImportImageResponse::kmsKeyId)).setter(ImportImageResponse.setter(Builder::kmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").unmarshallLocationName("kmsKeyId").build()}).build();
    private static final SdkField<String> LICENSE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ImportImageResponse.getter(ImportImageResponse::licenseType)).setter(ImportImageResponse.setter(Builder::licenseType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseType").unmarshallLocationName("licenseType").build()}).build();
    private static final SdkField<String> PLATFORM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ImportImageResponse.getter(ImportImageResponse::platform)).setter(ImportImageResponse.setter(Builder::platform)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Platform").unmarshallLocationName("platform").build()}).build();
    private static final SdkField<String> PROGRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ImportImageResponse.getter(ImportImageResponse::progress)).setter(ImportImageResponse.setter(Builder::progress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Progress").unmarshallLocationName("progress").build()}).build();
    private static final SdkField<List<SnapshotDetail>> SNAPSHOT_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ImportImageResponse.getter(ImportImageResponse::snapshotDetails)).setter(ImportImageResponse.setter(Builder::snapshotDetails)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotDetailSet").unmarshallLocationName("snapshotDetailSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SnapshotDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ImportImageResponse.getter(ImportImageResponse::status)).setter(ImportImageResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").unmarshallLocationName("status").build()}).build();
    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ImportImageResponse.getter(ImportImageResponse::statusMessage)).setter(ImportImageResponse.setter(Builder::statusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").unmarshallLocationName("statusMessage").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARCHITECTURE_FIELD, DESCRIPTION_FIELD, ENCRYPTED_FIELD, HYPERVISOR_FIELD, IMAGE_ID_FIELD, IMPORT_TASK_ID_FIELD, KMS_KEY_ID_FIELD, LICENSE_TYPE_FIELD, PLATFORM_FIELD, PROGRESS_FIELD, SNAPSHOT_DETAILS_FIELD, STATUS_FIELD, STATUS_MESSAGE_FIELD));
    private final String architecture;
    private final String description;
    private final Boolean encrypted;
    private final String hypervisor;
    private final String imageId;
    private final String importTaskId;
    private final String kmsKeyId;
    private final String licenseType;
    private final String platform;
    private final String progress;
    private final List<SnapshotDetail> snapshotDetails;
    private final String status;
    private final String statusMessage;

    private ImportImageResponse(BuilderImpl builder) {
        super(builder);
        this.architecture = builder.architecture;
        this.description = builder.description;
        this.encrypted = builder.encrypted;
        this.hypervisor = builder.hypervisor;
        this.imageId = builder.imageId;
        this.importTaskId = builder.importTaskId;
        this.kmsKeyId = builder.kmsKeyId;
        this.licenseType = builder.licenseType;
        this.platform = builder.platform;
        this.progress = builder.progress;
        this.snapshotDetails = builder.snapshotDetails;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
    }

    public String architecture() {
        return this.architecture;
    }

    public String description() {
        return this.description;
    }

    public Boolean encrypted() {
        return this.encrypted;
    }

    public String hypervisor() {
        return this.hypervisor;
    }

    public String imageId() {
        return this.imageId;
    }

    public String importTaskId() {
        return this.importTaskId;
    }

    public String kmsKeyId() {
        return this.kmsKeyId;
    }

    public String licenseType() {
        return this.licenseType;
    }

    public String platform() {
        return this.platform;
    }

    public String progress() {
        return this.progress;
    }

    public List<SnapshotDetail> snapshotDetails() {
        return this.snapshotDetails;
    }

    public String status() {
        return this.status;
    }

    public String statusMessage() {
        return this.statusMessage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.architecture());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.encrypted());
        hashCode = 31 * hashCode + Objects.hashCode(this.hypervisor());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageId());
        hashCode = 31 * hashCode + Objects.hashCode(this.importTaskId());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.licenseType());
        hashCode = 31 * hashCode + Objects.hashCode(this.platform());
        hashCode = 31 * hashCode + Objects.hashCode(this.progress());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusMessage());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportImageResponse)) {
            return false;
        }
        ImportImageResponse other = (ImportImageResponse)((Object)obj);
        return Objects.equals(this.architecture(), other.architecture()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.encrypted(), other.encrypted()) && Objects.equals(this.hypervisor(), other.hypervisor()) && Objects.equals(this.imageId(), other.imageId()) && Objects.equals(this.importTaskId(), other.importTaskId()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId()) && Objects.equals(this.licenseType(), other.licenseType()) && Objects.equals(this.platform(), other.platform()) && Objects.equals(this.progress(), other.progress()) && Objects.equals(this.snapshotDetails(), other.snapshotDetails()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.statusMessage(), other.statusMessage());
    }

    public String toString() {
        return ToString.builder((String)"ImportImageResponse").add("Architecture", (Object)this.architecture()).add("Description", (Object)this.description()).add("Encrypted", (Object)this.encrypted()).add("Hypervisor", (Object)this.hypervisor()).add("ImageId", (Object)this.imageId()).add("ImportTaskId", (Object)this.importTaskId()).add("KmsKeyId", (Object)this.kmsKeyId()).add("LicenseType", (Object)this.licenseType()).add("Platform", (Object)this.platform()).add("Progress", (Object)this.progress()).add("SnapshotDetails", this.snapshotDetails()).add("Status", (Object)this.status()).add("StatusMessage", (Object)this.statusMessage()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Architecture": {
                return Optional.ofNullable(clazz.cast(this.architecture()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Encrypted": {
                return Optional.ofNullable(clazz.cast(this.encrypted()));
            }
            case "Hypervisor": {
                return Optional.ofNullable(clazz.cast(this.hypervisor()));
            }
            case "ImageId": {
                return Optional.ofNullable(clazz.cast(this.imageId()));
            }
            case "ImportTaskId": {
                return Optional.ofNullable(clazz.cast(this.importTaskId()));
            }
            case "KmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
            case "LicenseType": {
                return Optional.ofNullable(clazz.cast(this.licenseType()));
            }
            case "Platform": {
                return Optional.ofNullable(clazz.cast(this.platform()));
            }
            case "Progress": {
                return Optional.ofNullable(clazz.cast(this.progress()));
            }
            case "SnapshotDetails": {
                return Optional.ofNullable(clazz.cast(this.snapshotDetails()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "StatusMessage": {
                return Optional.ofNullable(clazz.cast(this.statusMessage()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ImportImageResponse, T> g) {
        return obj -> g.apply((ImportImageResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private String architecture;
        private String description;
        private Boolean encrypted;
        private String hypervisor;
        private String imageId;
        private String importTaskId;
        private String kmsKeyId;
        private String licenseType;
        private String platform;
        private String progress;
        private List<SnapshotDetail> snapshotDetails = DefaultSdkAutoConstructList.getInstance();
        private String status;
        private String statusMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(ImportImageResponse model) {
            super(model);
            this.architecture(model.architecture);
            this.description(model.description);
            this.encrypted(model.encrypted);
            this.hypervisor(model.hypervisor);
            this.imageId(model.imageId);
            this.importTaskId(model.importTaskId);
            this.kmsKeyId(model.kmsKeyId);
            this.licenseType(model.licenseType);
            this.platform(model.platform);
            this.progress(model.progress);
            this.snapshotDetails(model.snapshotDetails);
            this.status(model.status);
            this.statusMessage(model.statusMessage);
        }

        public final String getArchitecture() {
            return this.architecture;
        }

        @Override
        public final Builder architecture(String architecture) {
            this.architecture = architecture;
            return this;
        }

        public final void setArchitecture(String architecture) {
            this.architecture = architecture;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Boolean getEncrypted() {
            return this.encrypted;
        }

        @Override
        public final Builder encrypted(Boolean encrypted) {
            this.encrypted = encrypted;
            return this;
        }

        public final void setEncrypted(Boolean encrypted) {
            this.encrypted = encrypted;
        }

        public final String getHypervisor() {
            return this.hypervisor;
        }

        @Override
        public final Builder hypervisor(String hypervisor) {
            this.hypervisor = hypervisor;
            return this;
        }

        public final void setHypervisor(String hypervisor) {
            this.hypervisor = hypervisor;
        }

        public final String getImageId() {
            return this.imageId;
        }

        @Override
        public final Builder imageId(String imageId) {
            this.imageId = imageId;
            return this;
        }

        public final void setImageId(String imageId) {
            this.imageId = imageId;
        }

        public final String getImportTaskId() {
            return this.importTaskId;
        }

        @Override
        public final Builder importTaskId(String importTaskId) {
            this.importTaskId = importTaskId;
            return this;
        }

        public final void setImportTaskId(String importTaskId) {
            this.importTaskId = importTaskId;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        public final String getLicenseType() {
            return this.licenseType;
        }

        @Override
        public final Builder licenseType(String licenseType) {
            this.licenseType = licenseType;
            return this;
        }

        public final void setLicenseType(String licenseType) {
            this.licenseType = licenseType;
        }

        public final String getPlatform() {
            return this.platform;
        }

        @Override
        public final Builder platform(String platform) {
            this.platform = platform;
            return this;
        }

        public final void setPlatform(String platform) {
            this.platform = platform;
        }

        public final String getProgress() {
            return this.progress;
        }

        @Override
        public final Builder progress(String progress) {
            this.progress = progress;
            return this;
        }

        public final void setProgress(String progress) {
            this.progress = progress;
        }

        public final Collection<SnapshotDetail.Builder> getSnapshotDetails() {
            return this.snapshotDetails != null ? (Collection)this.snapshotDetails.stream().map(SnapshotDetail::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder snapshotDetails(Collection<SnapshotDetail> snapshotDetails) {
            this.snapshotDetails = SnapshotDetailListCopier.copy(snapshotDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder snapshotDetails(SnapshotDetail ... snapshotDetails) {
            this.snapshotDetails(Arrays.asList(snapshotDetails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder snapshotDetails(Consumer<SnapshotDetail.Builder> ... snapshotDetails) {
            this.snapshotDetails(Stream.of(snapshotDetails).map(c -> (SnapshotDetail)((SnapshotDetail.Builder)SnapshotDetail.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSnapshotDetails(Collection<SnapshotDetail.BuilderImpl> snapshotDetails) {
            this.snapshotDetails = SnapshotDetailListCopier.copyFromBuilder(snapshotDetails);
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public ImportImageResponse build() {
            return new ImportImageResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ImportImageResponse> {
        public Builder architecture(String var1);

        public Builder description(String var1);

        public Builder encrypted(Boolean var1);

        public Builder hypervisor(String var1);

        public Builder imageId(String var1);

        public Builder importTaskId(String var1);

        public Builder kmsKeyId(String var1);

        public Builder licenseType(String var1);

        public Builder platform(String var1);

        public Builder progress(String var1);

        public Builder snapshotDetails(Collection<SnapshotDetail> var1);

        public Builder snapshotDetails(SnapshotDetail ... var1);

        public Builder snapshotDetails(Consumer<SnapshotDetail.Builder> ... var1);

        public Builder status(String var1);

        public Builder statusMessage(String var1);
    }
}

