/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.model.DescribeReservedInstancesModificationsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeReservedInstancesModificationsResponse;
import software.amazon.awssdk.services.ec2.model.ReservedInstancesModification;

public class DescribeReservedInstancesModificationsIterable
implements SdkIterable<DescribeReservedInstancesModificationsResponse> {
    private final Ec2Client client;
    private final DescribeReservedInstancesModificationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeReservedInstancesModificationsIterable(Ec2Client client, DescribeReservedInstancesModificationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeReservedInstancesModificationsResponseFetcher();
    }

    public Iterator<DescribeReservedInstancesModificationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ReservedInstancesModification> reservedInstancesModifications() {
        Function<DescribeReservedInstancesModificationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.reservedInstancesModifications() != null) {
                return response.reservedInstancesModifications().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private final DescribeReservedInstancesModificationsIterable resume(DescribeReservedInstancesModificationsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeReservedInstancesModificationsIterable(this.client, (DescribeReservedInstancesModificationsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new DescribeReservedInstancesModificationsIterable(this.client, this.firstRequest){

            @Override
            public Iterator<DescribeReservedInstancesModificationsResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class DescribeReservedInstancesModificationsResponseFetcher
    implements SyncPageFetcher<DescribeReservedInstancesModificationsResponse> {
        private DescribeReservedInstancesModificationsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeReservedInstancesModificationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeReservedInstancesModificationsResponse nextPage(DescribeReservedInstancesModificationsResponse previousPage) {
            if (previousPage == null) {
                return DescribeReservedInstancesModificationsIterable.this.client.describeReservedInstancesModifications(DescribeReservedInstancesModificationsIterable.this.firstRequest);
            }
            return DescribeReservedInstancesModificationsIterable.this.client.describeReservedInstancesModifications((DescribeReservedInstancesModificationsRequest)((Object)DescribeReservedInstancesModificationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

