/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.CapacityReservationPreference;
import software.amazon.awssdk.services.ec2.model.CapacityReservationTargetResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LaunchTemplateCapacityReservationSpecificationResponse
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LaunchTemplateCapacityReservationSpecificationResponse> {
    private static final SdkField<String> CAPACITY_RESERVATION_PREFERENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(LaunchTemplateCapacityReservationSpecificationResponse.getter(LaunchTemplateCapacityReservationSpecificationResponse::capacityReservationPreferenceAsString)).setter(LaunchTemplateCapacityReservationSpecificationResponse.setter(Builder::capacityReservationPreference)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityReservationPreference").unmarshallLocationName("capacityReservationPreference").build()}).build();
    private static final SdkField<CapacityReservationTargetResponse> CAPACITY_RESERVATION_TARGET_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(LaunchTemplateCapacityReservationSpecificationResponse.getter(LaunchTemplateCapacityReservationSpecificationResponse::capacityReservationTarget)).setter(LaunchTemplateCapacityReservationSpecificationResponse.setter(Builder::capacityReservationTarget)).constructor(CapacityReservationTargetResponse::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityReservationTarget").unmarshallLocationName("capacityReservationTarget").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CAPACITY_RESERVATION_PREFERENCE_FIELD, CAPACITY_RESERVATION_TARGET_FIELD));
    private static final long serialVersionUID = 1L;
    private final String capacityReservationPreference;
    private final CapacityReservationTargetResponse capacityReservationTarget;

    private LaunchTemplateCapacityReservationSpecificationResponse(BuilderImpl builder) {
        this.capacityReservationPreference = builder.capacityReservationPreference;
        this.capacityReservationTarget = builder.capacityReservationTarget;
    }

    public CapacityReservationPreference capacityReservationPreference() {
        return CapacityReservationPreference.fromValue(this.capacityReservationPreference);
    }

    public String capacityReservationPreferenceAsString() {
        return this.capacityReservationPreference;
    }

    public CapacityReservationTargetResponse capacityReservationTarget() {
        return this.capacityReservationTarget;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.capacityReservationPreferenceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.capacityReservationTarget());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LaunchTemplateCapacityReservationSpecificationResponse)) {
            return false;
        }
        LaunchTemplateCapacityReservationSpecificationResponse other = (LaunchTemplateCapacityReservationSpecificationResponse)obj;
        return Objects.equals(this.capacityReservationPreferenceAsString(), other.capacityReservationPreferenceAsString()) && Objects.equals(this.capacityReservationTarget(), other.capacityReservationTarget());
    }

    public String toString() {
        return ToString.builder((String)"LaunchTemplateCapacityReservationSpecificationResponse").add("CapacityReservationPreference", (Object)this.capacityReservationPreferenceAsString()).add("CapacityReservationTarget", (Object)this.capacityReservationTarget()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CapacityReservationPreference": {
                return Optional.ofNullable(clazz.cast(this.capacityReservationPreferenceAsString()));
            }
            case "CapacityReservationTarget": {
                return Optional.ofNullable(clazz.cast(this.capacityReservationTarget()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LaunchTemplateCapacityReservationSpecificationResponse, T> g) {
        return obj -> g.apply((LaunchTemplateCapacityReservationSpecificationResponse)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String capacityReservationPreference;
        private CapacityReservationTargetResponse capacityReservationTarget;

        private BuilderImpl() {
        }

        private BuilderImpl(LaunchTemplateCapacityReservationSpecificationResponse model) {
            this.capacityReservationPreference(model.capacityReservationPreference);
            this.capacityReservationTarget(model.capacityReservationTarget);
        }

        public final String getCapacityReservationPreference() {
            return this.capacityReservationPreference;
        }

        @Override
        public final Builder capacityReservationPreference(String capacityReservationPreference) {
            this.capacityReservationPreference = capacityReservationPreference;
            return this;
        }

        @Override
        public final Builder capacityReservationPreference(CapacityReservationPreference capacityReservationPreference) {
            this.capacityReservationPreference(capacityReservationPreference.toString());
            return this;
        }

        public final void setCapacityReservationPreference(String capacityReservationPreference) {
            this.capacityReservationPreference = capacityReservationPreference;
        }

        public final CapacityReservationTargetResponse.Builder getCapacityReservationTarget() {
            return this.capacityReservationTarget != null ? this.capacityReservationTarget.toBuilder() : null;
        }

        @Override
        public final Builder capacityReservationTarget(CapacityReservationTargetResponse capacityReservationTarget) {
            this.capacityReservationTarget = capacityReservationTarget;
            return this;
        }

        public final void setCapacityReservationTarget(CapacityReservationTargetResponse.BuilderImpl capacityReservationTarget) {
            this.capacityReservationTarget = capacityReservationTarget != null ? capacityReservationTarget.build() : null;
        }

        public LaunchTemplateCapacityReservationSpecificationResponse build() {
            return new LaunchTemplateCapacityReservationSpecificationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LaunchTemplateCapacityReservationSpecificationResponse> {
        public Builder capacityReservationPreference(String var1);

        public Builder capacityReservationPreference(CapacityReservationPreference var1);

        public Builder capacityReservationTarget(CapacityReservationTargetResponse var1);

        default public Builder capacityReservationTarget(Consumer<CapacityReservationTargetResponse.Builder> capacityReservationTarget) {
            return this.capacityReservationTarget((CapacityReservationTargetResponse)((CapacityReservationTargetResponse.Builder)CapacityReservationTargetResponse.builder().applyMutation(capacityReservationTarget)).build());
        }
    }
}

