/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.SpotAllocationStrategy;
import software.amazon.awssdk.services.ec2.model.SpotInstanceInterruptionBehavior;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SpotOptionsRequest
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SpotOptionsRequest> {
    private static final SdkField<String> ALLOCATION_STRATEGY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SpotOptionsRequest.getter(SpotOptionsRequest::allocationStrategyAsString)).setter(SpotOptionsRequest.setter(Builder::allocationStrategy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllocationStrategy").unmarshallLocationName("AllocationStrategy").build()}).build();
    private static final SdkField<String> INSTANCE_INTERRUPTION_BEHAVIOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SpotOptionsRequest.getter(SpotOptionsRequest::instanceInterruptionBehaviorAsString)).setter(SpotOptionsRequest.setter(Builder::instanceInterruptionBehavior)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceInterruptionBehavior").unmarshallLocationName("InstanceInterruptionBehavior").build()}).build();
    private static final SdkField<Integer> INSTANCE_POOLS_TO_USE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(SpotOptionsRequest.getter(SpotOptionsRequest::instancePoolsToUseCount)).setter(SpotOptionsRequest.setter(Builder::instancePoolsToUseCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstancePoolsToUseCount").unmarshallLocationName("InstancePoolsToUseCount").build()}).build();
    private static final SdkField<Boolean> SINGLE_INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(SpotOptionsRequest.getter(SpotOptionsRequest::singleInstanceType)).setter(SpotOptionsRequest.setter(Builder::singleInstanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SingleInstanceType").unmarshallLocationName("SingleInstanceType").build()}).build();
    private static final SdkField<Integer> MIN_TARGET_CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(SpotOptionsRequest.getter(SpotOptionsRequest::minTargetCapacity)).setter(SpotOptionsRequest.setter(Builder::minTargetCapacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinTargetCapacity").unmarshallLocationName("MinTargetCapacity").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALLOCATION_STRATEGY_FIELD, INSTANCE_INTERRUPTION_BEHAVIOR_FIELD, INSTANCE_POOLS_TO_USE_COUNT_FIELD, SINGLE_INSTANCE_TYPE_FIELD, MIN_TARGET_CAPACITY_FIELD));
    private static final long serialVersionUID = 1L;
    private final String allocationStrategy;
    private final String instanceInterruptionBehavior;
    private final Integer instancePoolsToUseCount;
    private final Boolean singleInstanceType;
    private final Integer minTargetCapacity;

    private SpotOptionsRequest(BuilderImpl builder) {
        this.allocationStrategy = builder.allocationStrategy;
        this.instanceInterruptionBehavior = builder.instanceInterruptionBehavior;
        this.instancePoolsToUseCount = builder.instancePoolsToUseCount;
        this.singleInstanceType = builder.singleInstanceType;
        this.minTargetCapacity = builder.minTargetCapacity;
    }

    public SpotAllocationStrategy allocationStrategy() {
        return SpotAllocationStrategy.fromValue(this.allocationStrategy);
    }

    public String allocationStrategyAsString() {
        return this.allocationStrategy;
    }

    public SpotInstanceInterruptionBehavior instanceInterruptionBehavior() {
        return SpotInstanceInterruptionBehavior.fromValue(this.instanceInterruptionBehavior);
    }

    public String instanceInterruptionBehaviorAsString() {
        return this.instanceInterruptionBehavior;
    }

    public Integer instancePoolsToUseCount() {
        return this.instancePoolsToUseCount;
    }

    public Boolean singleInstanceType() {
        return this.singleInstanceType;
    }

    public Integer minTargetCapacity() {
        return this.minTargetCapacity;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.allocationStrategyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceInterruptionBehaviorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.instancePoolsToUseCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.singleInstanceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.minTargetCapacity());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SpotOptionsRequest)) {
            return false;
        }
        SpotOptionsRequest other = (SpotOptionsRequest)obj;
        return Objects.equals(this.allocationStrategyAsString(), other.allocationStrategyAsString()) && Objects.equals(this.instanceInterruptionBehaviorAsString(), other.instanceInterruptionBehaviorAsString()) && Objects.equals(this.instancePoolsToUseCount(), other.instancePoolsToUseCount()) && Objects.equals(this.singleInstanceType(), other.singleInstanceType()) && Objects.equals(this.minTargetCapacity(), other.minTargetCapacity());
    }

    public String toString() {
        return ToString.builder((String)"SpotOptionsRequest").add("AllocationStrategy", (Object)this.allocationStrategyAsString()).add("InstanceInterruptionBehavior", (Object)this.instanceInterruptionBehaviorAsString()).add("InstancePoolsToUseCount", (Object)this.instancePoolsToUseCount()).add("SingleInstanceType", (Object)this.singleInstanceType()).add("MinTargetCapacity", (Object)this.minTargetCapacity()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AllocationStrategy": {
                return Optional.ofNullable(clazz.cast(this.allocationStrategyAsString()));
            }
            case "InstanceInterruptionBehavior": {
                return Optional.ofNullable(clazz.cast(this.instanceInterruptionBehaviorAsString()));
            }
            case "InstancePoolsToUseCount": {
                return Optional.ofNullable(clazz.cast(this.instancePoolsToUseCount()));
            }
            case "SingleInstanceType": {
                return Optional.ofNullable(clazz.cast(this.singleInstanceType()));
            }
            case "MinTargetCapacity": {
                return Optional.ofNullable(clazz.cast(this.minTargetCapacity()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SpotOptionsRequest, T> g) {
        return obj -> g.apply((SpotOptionsRequest)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String allocationStrategy;
        private String instanceInterruptionBehavior;
        private Integer instancePoolsToUseCount;
        private Boolean singleInstanceType;
        private Integer minTargetCapacity;

        private BuilderImpl() {
        }

        private BuilderImpl(SpotOptionsRequest model) {
            this.allocationStrategy(model.allocationStrategy);
            this.instanceInterruptionBehavior(model.instanceInterruptionBehavior);
            this.instancePoolsToUseCount(model.instancePoolsToUseCount);
            this.singleInstanceType(model.singleInstanceType);
            this.minTargetCapacity(model.minTargetCapacity);
        }

        public final String getAllocationStrategy() {
            return this.allocationStrategy;
        }

        @Override
        public final Builder allocationStrategy(String allocationStrategy) {
            this.allocationStrategy = allocationStrategy;
            return this;
        }

        @Override
        public final Builder allocationStrategy(SpotAllocationStrategy allocationStrategy) {
            this.allocationStrategy(allocationStrategy.toString());
            return this;
        }

        public final void setAllocationStrategy(String allocationStrategy) {
            this.allocationStrategy = allocationStrategy;
        }

        public final String getInstanceInterruptionBehavior() {
            return this.instanceInterruptionBehavior;
        }

        @Override
        public final Builder instanceInterruptionBehavior(String instanceInterruptionBehavior) {
            this.instanceInterruptionBehavior = instanceInterruptionBehavior;
            return this;
        }

        @Override
        public final Builder instanceInterruptionBehavior(SpotInstanceInterruptionBehavior instanceInterruptionBehavior) {
            this.instanceInterruptionBehavior(instanceInterruptionBehavior.toString());
            return this;
        }

        public final void setInstanceInterruptionBehavior(String instanceInterruptionBehavior) {
            this.instanceInterruptionBehavior = instanceInterruptionBehavior;
        }

        public final Integer getInstancePoolsToUseCount() {
            return this.instancePoolsToUseCount;
        }

        @Override
        public final Builder instancePoolsToUseCount(Integer instancePoolsToUseCount) {
            this.instancePoolsToUseCount = instancePoolsToUseCount;
            return this;
        }

        public final void setInstancePoolsToUseCount(Integer instancePoolsToUseCount) {
            this.instancePoolsToUseCount = instancePoolsToUseCount;
        }

        public final Boolean getSingleInstanceType() {
            return this.singleInstanceType;
        }

        @Override
        public final Builder singleInstanceType(Boolean singleInstanceType) {
            this.singleInstanceType = singleInstanceType;
            return this;
        }

        public final void setSingleInstanceType(Boolean singleInstanceType) {
            this.singleInstanceType = singleInstanceType;
        }

        public final Integer getMinTargetCapacity() {
            return this.minTargetCapacity;
        }

        @Override
        public final Builder minTargetCapacity(Integer minTargetCapacity) {
            this.minTargetCapacity = minTargetCapacity;
            return this;
        }

        public final void setMinTargetCapacity(Integer minTargetCapacity) {
            this.minTargetCapacity = minTargetCapacity;
        }

        public SpotOptionsRequest build() {
            return new SpotOptionsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SpotOptionsRequest> {
        public Builder allocationStrategy(String var1);

        public Builder allocationStrategy(SpotAllocationStrategy var1);

        public Builder instanceInterruptionBehavior(String var1);

        public Builder instanceInterruptionBehavior(SpotInstanceInterruptionBehavior var1);

        public Builder instancePoolsToUseCount(Integer var1);

        public Builder singleInstanceType(Boolean var1);

        public Builder minTargetCapacity(Integer var1);
    }
}

