/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum RuleAction {
    ALLOW("allow"),
    DENY("deny"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private RuleAction(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static RuleAction fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(RuleAction.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<RuleAction> knownValues() {
        return Stream.of(RuleAction.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

