/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.LaunchTemplateVersion;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateLaunchTemplateVersionResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, CreateLaunchTemplateVersionResponse> {
    private static final SdkField<LaunchTemplateVersion> LAUNCH_TEMPLATE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CreateLaunchTemplateVersionResponse.getter(CreateLaunchTemplateVersionResponse::launchTemplateVersion)).setter(CreateLaunchTemplateVersionResponse.setter(Builder::launchTemplateVersion)).constructor(LaunchTemplateVersion::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchTemplateVersion").unmarshallLocationName("launchTemplateVersion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAUNCH_TEMPLATE_VERSION_FIELD));
    private final LaunchTemplateVersion launchTemplateVersion;

    private CreateLaunchTemplateVersionResponse(BuilderImpl builder) {
        super(builder);
        this.launchTemplateVersion = builder.launchTemplateVersion;
    }

    public LaunchTemplateVersion launchTemplateVersion() {
        return this.launchTemplateVersion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.launchTemplateVersion());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateLaunchTemplateVersionResponse)) {
            return false;
        }
        CreateLaunchTemplateVersionResponse other = (CreateLaunchTemplateVersionResponse)((Object)obj);
        return Objects.equals(this.launchTemplateVersion(), other.launchTemplateVersion());
    }

    public String toString() {
        return ToString.builder((String)"CreateLaunchTemplateVersionResponse").add("LaunchTemplateVersion", (Object)this.launchTemplateVersion()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LaunchTemplateVersion": {
                return Optional.ofNullable(clazz.cast(this.launchTemplateVersion()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateLaunchTemplateVersionResponse, T> g) {
        return obj -> g.apply((CreateLaunchTemplateVersionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private LaunchTemplateVersion launchTemplateVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateLaunchTemplateVersionResponse model) {
            super(model);
            this.launchTemplateVersion(model.launchTemplateVersion);
        }

        public final LaunchTemplateVersion.Builder getLaunchTemplateVersion() {
            return this.launchTemplateVersion != null ? this.launchTemplateVersion.toBuilder() : null;
        }

        @Override
        public final Builder launchTemplateVersion(LaunchTemplateVersion launchTemplateVersion) {
            this.launchTemplateVersion = launchTemplateVersion;
            return this;
        }

        public final void setLaunchTemplateVersion(LaunchTemplateVersion.BuilderImpl launchTemplateVersion) {
            this.launchTemplateVersion = launchTemplateVersion != null ? launchTemplateVersion.build() : null;
        }

        @Override
        public CreateLaunchTemplateVersionResponse build() {
            return new CreateLaunchTemplateVersionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateLaunchTemplateVersionResponse> {
        public Builder launchTemplateVersion(LaunchTemplateVersion var1);

        default public Builder launchTemplateVersion(Consumer<LaunchTemplateVersion.Builder> launchTemplateVersion) {
            return this.launchTemplateVersion((LaunchTemplateVersion)((LaunchTemplateVersion.Builder)LaunchTemplateVersion.builder().applyMutation(launchTemplateVersion)).build());
        }
    }
}

