/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.ec2.model.IcmpTypeCode;
import software.amazon.awssdk.services.ec2.model.PortRange;
import software.amazon.awssdk.services.ec2.model.ReplaceNetworkAclEntryRequest;

public class ReplaceNetworkAclEntryRequestMarshaller
implements Marshaller<Request<ReplaceNetworkAclEntryRequest>, ReplaceNetworkAclEntryRequest> {
    public Request<ReplaceNetworkAclEntryRequest> marshall(ReplaceNetworkAclEntryRequest replaceNetworkAclEntryRequest) {
        PortRange portRange;
        IcmpTypeCode icmpTypeCode;
        if (replaceNetworkAclEntryRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)replaceNetworkAclEntryRequest, "EC2Client");
        request.addParameter("Action", "ReplaceNetworkAclEntry");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (replaceNetworkAclEntryRequest.cidrBlock() != null) {
            request.addParameter("CidrBlock", StringUtils.fromString((String)replaceNetworkAclEntryRequest.cidrBlock()));
        }
        if (replaceNetworkAclEntryRequest.egress() != null) {
            request.addParameter("Egress", StringUtils.fromBoolean((Boolean)replaceNetworkAclEntryRequest.egress()));
        }
        if ((icmpTypeCode = replaceNetworkAclEntryRequest.icmpTypeCode()) != null) {
            if (icmpTypeCode.code() != null) {
                request.addParameter("Icmp.Code", StringUtils.fromInteger((Integer)icmpTypeCode.code()));
            }
            if (icmpTypeCode.type() != null) {
                request.addParameter("Icmp.Type", StringUtils.fromInteger((Integer)icmpTypeCode.type()));
            }
        }
        if (replaceNetworkAclEntryRequest.ipv6CidrBlock() != null) {
            request.addParameter("Ipv6CidrBlock", StringUtils.fromString((String)replaceNetworkAclEntryRequest.ipv6CidrBlock()));
        }
        if (replaceNetworkAclEntryRequest.networkAclId() != null) {
            request.addParameter("NetworkAclId", StringUtils.fromString((String)replaceNetworkAclEntryRequest.networkAclId()));
        }
        if ((portRange = replaceNetworkAclEntryRequest.portRange()) != null) {
            if (portRange.from() != null) {
                request.addParameter("PortRange.From", StringUtils.fromInteger((Integer)portRange.from()));
            }
            if (portRange.to() != null) {
                request.addParameter("PortRange.To", StringUtils.fromInteger((Integer)portRange.to()));
            }
        }
        if (replaceNetworkAclEntryRequest.protocol() != null) {
            request.addParameter("Protocol", StringUtils.fromString((String)replaceNetworkAclEntryRequest.protocol()));
        }
        if (replaceNetworkAclEntryRequest.ruleActionString() != null) {
            request.addParameter("RuleAction", StringUtils.fromString((String)replaceNetworkAclEntryRequest.ruleActionString()));
        }
        if (replaceNetworkAclEntryRequest.ruleNumber() != null) {
            request.addParameter("RuleNumber", StringUtils.fromInteger((Integer)replaceNetworkAclEntryRequest.ruleNumber()));
        }
        return request;
    }
}

