/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.ec2.model.ModifySpotFleetRequestRequest;

public class ModifySpotFleetRequestRequestMarshaller
implements Marshaller<Request<ModifySpotFleetRequestRequest>, ModifySpotFleetRequestRequest> {
    public Request<ModifySpotFleetRequestRequest> marshall(ModifySpotFleetRequestRequest modifySpotFleetRequestRequest) {
        if (modifySpotFleetRequestRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)modifySpotFleetRequestRequest, "EC2Client");
        request.addParameter("Action", "ModifySpotFleetRequest");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (modifySpotFleetRequestRequest.excessCapacityTerminationPolicyString() != null) {
            request.addParameter("ExcessCapacityTerminationPolicy", StringUtils.fromString((String)modifySpotFleetRequestRequest.excessCapacityTerminationPolicyString()));
        }
        if (modifySpotFleetRequestRequest.spotFleetRequestId() != null) {
            request.addParameter("SpotFleetRequestId", StringUtils.fromString((String)modifySpotFleetRequestRequest.spotFleetRequestId()));
        }
        if (modifySpotFleetRequestRequest.targetCapacity() != null) {
            request.addParameter("TargetCapacity", StringUtils.fromInteger((Integer)modifySpotFleetRequestRequest.targetCapacity()));
        }
        return request;
    }
}

