/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.ec2.model.DeleteRouteRequest;

public class DeleteRouteRequestMarshaller
implements Marshaller<Request<DeleteRouteRequest>, DeleteRouteRequest> {
    public Request<DeleteRouteRequest> marshall(DeleteRouteRequest deleteRouteRequest) {
        if (deleteRouteRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)deleteRouteRequest, "EC2Client");
        request.addParameter("Action", "DeleteRoute");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (deleteRouteRequest.destinationCidrBlock() != null) {
            request.addParameter("DestinationCidrBlock", StringUtils.fromString((String)deleteRouteRequest.destinationCidrBlock()));
        }
        if (deleteRouteRequest.destinationIpv6CidrBlock() != null) {
            request.addParameter("DestinationIpv6CidrBlock", StringUtils.fromString((String)deleteRouteRequest.destinationIpv6CidrBlock()));
        }
        if (deleteRouteRequest.routeTableId() != null) {
            request.addParameter("RouteTableId", StringUtils.fromString((String)deleteRouteRequest.routeTableId()));
        }
        return request;
    }
}

