/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.pagination.async.SdkPublisher;
import software.amazon.awssdk.services.ec2.EC2AsyncClient;
import software.amazon.awssdk.services.ec2.model.DescribeSpotPriceHistoryRequest;
import software.amazon.awssdk.services.ec2.model.DescribeSpotPriceHistoryResponse;
import software.amazon.awssdk.services.ec2.model.SpotPrice;

public class DescribeSpotPriceHistoryPublisher
implements SdkPublisher<DescribeSpotPriceHistoryResponse> {
    private final EC2AsyncClient client;
    private final DescribeSpotPriceHistoryRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeSpotPriceHistoryPublisher(EC2AsyncClient client, DescribeSpotPriceHistoryRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeSpotPriceHistoryPublisher(EC2AsyncClient client, DescribeSpotPriceHistoryRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeSpotPriceHistoryResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeSpotPriceHistoryResponse> subscriber) {
        subscriber.onSubscribe((Subscription)new ResponsesSubscription(subscriber, this.nextPageFetcher));
    }

    public final SdkPublisher<SpotPrice> spotPriceHistory() {
        Function<DescribeSpotPriceHistoryResponse, Iterator> getIterator = response -> {
            if (response != null && response.spotPriceHistory() != null) {
                return response.spotPriceHistory().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsPublisher((AsyncPageFetcher)new DescribeSpotPriceHistoryResponseFetcher(), getIterator, this.isLastPage);
    }

    public final DescribeSpotPriceHistoryPublisher resume(DescribeSpotPriceHistoryResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeSpotPriceHistoryPublisher(this.client, (DescribeSpotPriceHistoryRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new DescribeSpotPriceHistoryPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super DescribeSpotPriceHistoryResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class DescribeSpotPriceHistoryResponseFetcher
    implements AsyncPageFetcher<DescribeSpotPriceHistoryResponse> {
        private DescribeSpotPriceHistoryResponseFetcher() {
        }

        public boolean hasNextPage(DescribeSpotPriceHistoryResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public CompletableFuture<DescribeSpotPriceHistoryResponse> nextPage(DescribeSpotPriceHistoryResponse previousPage) {
            if (previousPage == null) {
                return DescribeSpotPriceHistoryPublisher.this.client.describeSpotPriceHistory(DescribeSpotPriceHistoryPublisher.this.firstRequest);
            }
            return DescribeSpotPriceHistoryPublisher.this.client.describeSpotPriceHistory((DescribeSpotPriceHistoryRequest)((Object)DescribeSpotPriceHistoryPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

