/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.pagination.async.SdkPublisher;
import software.amazon.awssdk.services.ec2.EC2AsyncClient;
import software.amazon.awssdk.services.ec2.model.DescribeReservedInstancesModificationsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeReservedInstancesModificationsResponse;
import software.amazon.awssdk.services.ec2.model.ReservedInstancesModification;

public class DescribeReservedInstancesModificationsPublisher
implements SdkPublisher<DescribeReservedInstancesModificationsResponse> {
    private final EC2AsyncClient client;
    private final DescribeReservedInstancesModificationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeReservedInstancesModificationsPublisher(EC2AsyncClient client, DescribeReservedInstancesModificationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeReservedInstancesModificationsPublisher(EC2AsyncClient client, DescribeReservedInstancesModificationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeReservedInstancesModificationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeReservedInstancesModificationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)new ResponsesSubscription(subscriber, this.nextPageFetcher));
    }

    public final SdkPublisher<ReservedInstancesModification> reservedInstancesModifications() {
        Function<DescribeReservedInstancesModificationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.reservedInstancesModifications() != null) {
                return response.reservedInstancesModifications().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsPublisher((AsyncPageFetcher)new DescribeReservedInstancesModificationsResponseFetcher(), getIterator, this.isLastPage);
    }

    public final DescribeReservedInstancesModificationsPublisher resume(DescribeReservedInstancesModificationsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeReservedInstancesModificationsPublisher(this.client, (DescribeReservedInstancesModificationsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new DescribeReservedInstancesModificationsPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super DescribeReservedInstancesModificationsResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class DescribeReservedInstancesModificationsResponseFetcher
    implements AsyncPageFetcher<DescribeReservedInstancesModificationsResponse> {
        private DescribeReservedInstancesModificationsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeReservedInstancesModificationsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public CompletableFuture<DescribeReservedInstancesModificationsResponse> nextPage(DescribeReservedInstancesModificationsResponse previousPage) {
            if (previousPage == null) {
                return DescribeReservedInstancesModificationsPublisher.this.client.describeReservedInstancesModifications(DescribeReservedInstancesModificationsPublisher.this.firstRequest);
            }
            return DescribeReservedInstancesModificationsPublisher.this.client.describeReservedInstancesModifications((DescribeReservedInstancesModificationsRequest)((Object)DescribeReservedInstancesModificationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

