/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.pagination.async.SdkPublisher;
import software.amazon.awssdk.services.ec2.EC2AsyncClient;
import software.amazon.awssdk.services.ec2.model.DescribeInstanceStatusRequest;
import software.amazon.awssdk.services.ec2.model.DescribeInstanceStatusResponse;
import software.amazon.awssdk.services.ec2.model.InstanceStatus;

public class DescribeInstanceStatusPublisher
implements SdkPublisher<DescribeInstanceStatusResponse> {
    private final EC2AsyncClient client;
    private final DescribeInstanceStatusRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeInstanceStatusPublisher(EC2AsyncClient client, DescribeInstanceStatusRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeInstanceStatusPublisher(EC2AsyncClient client, DescribeInstanceStatusRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeInstanceStatusResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeInstanceStatusResponse> subscriber) {
        subscriber.onSubscribe((Subscription)new ResponsesSubscription(subscriber, this.nextPageFetcher));
    }

    public final SdkPublisher<InstanceStatus> instanceStatuses() {
        Function<DescribeInstanceStatusResponse, Iterator> getIterator = response -> {
            if (response != null && response.instanceStatuses() != null) {
                return response.instanceStatuses().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsPublisher((AsyncPageFetcher)new DescribeInstanceStatusResponseFetcher(), getIterator, this.isLastPage);
    }

    public final DescribeInstanceStatusPublisher resume(DescribeInstanceStatusResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeInstanceStatusPublisher(this.client, (DescribeInstanceStatusRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new DescribeInstanceStatusPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super DescribeInstanceStatusResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class DescribeInstanceStatusResponseFetcher
    implements AsyncPageFetcher<DescribeInstanceStatusResponse> {
        private DescribeInstanceStatusResponseFetcher() {
        }

        public boolean hasNextPage(DescribeInstanceStatusResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public CompletableFuture<DescribeInstanceStatusResponse> nextPage(DescribeInstanceStatusResponse previousPage) {
            if (previousPage == null) {
                return DescribeInstanceStatusPublisher.this.client.describeInstanceStatus(DescribeInstanceStatusPublisher.this.firstRequest);
            }
            return DescribeInstanceStatusPublisher.this.client.describeInstanceStatus((DescribeInstanceStatusRequest)((Object)DescribeInstanceStatusPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

