/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.services.ec2.model.VpcCidrBlockState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class VpcIpv6CidrBlockAssociation
implements ToCopyableBuilder<Builder, VpcIpv6CidrBlockAssociation> {
    private final String associationId;
    private final String ipv6CidrBlock;
    private final VpcCidrBlockState ipv6CidrBlockState;

    private VpcIpv6CidrBlockAssociation(BuilderImpl builder) {
        this.associationId = builder.associationId;
        this.ipv6CidrBlock = builder.ipv6CidrBlock;
        this.ipv6CidrBlockState = builder.ipv6CidrBlockState;
    }

    public String associationId() {
        return this.associationId;
    }

    public String ipv6CidrBlock() {
        return this.ipv6CidrBlock;
    }

    public VpcCidrBlockState ipv6CidrBlockState() {
        return this.ipv6CidrBlockState;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.associationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipv6CidrBlock());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipv6CidrBlockState());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VpcIpv6CidrBlockAssociation)) {
            return false;
        }
        VpcIpv6CidrBlockAssociation other = (VpcIpv6CidrBlockAssociation)obj;
        return Objects.equals(this.associationId(), other.associationId()) && Objects.equals(this.ipv6CidrBlock(), other.ipv6CidrBlock()) && Objects.equals(this.ipv6CidrBlockState(), other.ipv6CidrBlockState());
    }

    public String toString() {
        return ToString.builder((String)"VpcIpv6CidrBlockAssociation").add("AssociationId", (Object)this.associationId()).add("Ipv6CidrBlock", (Object)this.ipv6CidrBlock()).add("Ipv6CidrBlockState", (Object)this.ipv6CidrBlockState()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AssociationId": {
                return Optional.of(clazz.cast(this.associationId()));
            }
            case "Ipv6CidrBlock": {
                return Optional.of(clazz.cast(this.ipv6CidrBlock()));
            }
            case "Ipv6CidrBlockState": {
                return Optional.of(clazz.cast(this.ipv6CidrBlockState()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String associationId;
        private String ipv6CidrBlock;
        private VpcCidrBlockState ipv6CidrBlockState;

        private BuilderImpl() {
        }

        private BuilderImpl(VpcIpv6CidrBlockAssociation model) {
            this.associationId(model.associationId);
            this.ipv6CidrBlock(model.ipv6CidrBlock);
            this.ipv6CidrBlockState(model.ipv6CidrBlockState);
        }

        public final String getAssociationId() {
            return this.associationId;
        }

        @Override
        public final Builder associationId(String associationId) {
            this.associationId = associationId;
            return this;
        }

        public final void setAssociationId(String associationId) {
            this.associationId = associationId;
        }

        public final String getIpv6CidrBlock() {
            return this.ipv6CidrBlock;
        }

        @Override
        public final Builder ipv6CidrBlock(String ipv6CidrBlock) {
            this.ipv6CidrBlock = ipv6CidrBlock;
            return this;
        }

        public final void setIpv6CidrBlock(String ipv6CidrBlock) {
            this.ipv6CidrBlock = ipv6CidrBlock;
        }

        public final VpcCidrBlockState.Builder getIpv6CidrBlockState() {
            return this.ipv6CidrBlockState != null ? this.ipv6CidrBlockState.toBuilder() : null;
        }

        @Override
        public final Builder ipv6CidrBlockState(VpcCidrBlockState ipv6CidrBlockState) {
            this.ipv6CidrBlockState = ipv6CidrBlockState;
            return this;
        }

        public final void setIpv6CidrBlockState(VpcCidrBlockState.BuilderImpl ipv6CidrBlockState) {
            this.ipv6CidrBlockState = ipv6CidrBlockState != null ? ipv6CidrBlockState.build() : null;
        }

        public VpcIpv6CidrBlockAssociation build() {
            return new VpcIpv6CidrBlockAssociation(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, VpcIpv6CidrBlockAssociation> {
        public Builder associationId(String var1);

        public Builder ipv6CidrBlock(String var1);

        public Builder ipv6CidrBlockState(VpcCidrBlockState var1);

        default public Builder ipv6CidrBlockState(Consumer<VpcCidrBlockState.Builder> ipv6CidrBlockState) {
            return this.ipv6CidrBlockState((VpcCidrBlockState)((VpcCidrBlockState.Builder)VpcCidrBlockState.builder().apply(ipv6CidrBlockState)).build());
        }
    }
}

