/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.ec2.model.PropagatingVgw;
import software.amazon.awssdk.services.ec2.model.PropagatingVgwListCopier;
import software.amazon.awssdk.services.ec2.model.Route;
import software.amazon.awssdk.services.ec2.model.RouteListCopier;
import software.amazon.awssdk.services.ec2.model.RouteTableAssociation;
import software.amazon.awssdk.services.ec2.model.RouteTableAssociationListCopier;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class RouteTable
implements ToCopyableBuilder<Builder, RouteTable> {
    private final List<RouteTableAssociation> associations;
    private final List<PropagatingVgw> propagatingVgws;
    private final String routeTableId;
    private final List<Route> routes;
    private final List<Tag> tags;
    private final String vpcId;

    private RouteTable(BuilderImpl builder) {
        this.associations = builder.associations;
        this.propagatingVgws = builder.propagatingVgws;
        this.routeTableId = builder.routeTableId;
        this.routes = builder.routes;
        this.tags = builder.tags;
        this.vpcId = builder.vpcId;
    }

    public List<RouteTableAssociation> associations() {
        return this.associations;
    }

    public List<PropagatingVgw> propagatingVgws() {
        return this.propagatingVgws;
    }

    public String routeTableId() {
        return this.routeTableId;
    }

    public List<Route> routes() {
        return this.routes;
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public String vpcId() {
        return this.vpcId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.associations());
        hashCode = 31 * hashCode + Objects.hashCode(this.propagatingVgws());
        hashCode = 31 * hashCode + Objects.hashCode(this.routeTableId());
        hashCode = 31 * hashCode + Objects.hashCode(this.routes());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RouteTable)) {
            return false;
        }
        RouteTable other = (RouteTable)obj;
        return Objects.equals(this.associations(), other.associations()) && Objects.equals(this.propagatingVgws(), other.propagatingVgws()) && Objects.equals(this.routeTableId(), other.routeTableId()) && Objects.equals(this.routes(), other.routes()) && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.vpcId(), other.vpcId());
    }

    public String toString() {
        return ToString.builder((String)"RouteTable").add("Associations", this.associations()).add("PropagatingVgws", this.propagatingVgws()).add("RouteTableId", (Object)this.routeTableId()).add("Routes", this.routes()).add("Tags", this.tags()).add("VpcId", (Object)this.vpcId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Associations": {
                return Optional.of(clazz.cast(this.associations()));
            }
            case "PropagatingVgws": {
                return Optional.of(clazz.cast(this.propagatingVgws()));
            }
            case "RouteTableId": {
                return Optional.of(clazz.cast(this.routeTableId()));
            }
            case "Routes": {
                return Optional.of(clazz.cast(this.routes()));
            }
            case "Tags": {
                return Optional.of(clazz.cast(this.tags()));
            }
            case "VpcId": {
                return Optional.of(clazz.cast(this.vpcId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<RouteTableAssociation> associations;
        private List<PropagatingVgw> propagatingVgws;
        private String routeTableId;
        private List<Route> routes;
        private List<Tag> tags;
        private String vpcId;

        private BuilderImpl() {
        }

        private BuilderImpl(RouteTable model) {
            this.associations(model.associations);
            this.propagatingVgws(model.propagatingVgws);
            this.routeTableId(model.routeTableId);
            this.routes(model.routes);
            this.tags(model.tags);
            this.vpcId(model.vpcId);
        }

        public final Collection<RouteTableAssociation.Builder> getAssociations() {
            return this.associations != null ? (Collection)this.associations.stream().map(RouteTableAssociation::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder associations(Collection<RouteTableAssociation> associations) {
            this.associations = RouteTableAssociationListCopier.copy(associations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associations(RouteTableAssociation ... associations) {
            this.associations(Arrays.asList(associations));
            return this;
        }

        public final void setAssociations(Collection<RouteTableAssociation.BuilderImpl> associations) {
            this.associations = RouteTableAssociationListCopier.copyFromBuilder(associations);
        }

        public final Collection<PropagatingVgw.Builder> getPropagatingVgws() {
            return this.propagatingVgws != null ? (Collection)this.propagatingVgws.stream().map(PropagatingVgw::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder propagatingVgws(Collection<PropagatingVgw> propagatingVgws) {
            this.propagatingVgws = PropagatingVgwListCopier.copy(propagatingVgws);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder propagatingVgws(PropagatingVgw ... propagatingVgws) {
            this.propagatingVgws(Arrays.asList(propagatingVgws));
            return this;
        }

        public final void setPropagatingVgws(Collection<PropagatingVgw.BuilderImpl> propagatingVgws) {
            this.propagatingVgws = PropagatingVgwListCopier.copyFromBuilder(propagatingVgws);
        }

        public final String getRouteTableId() {
            return this.routeTableId;
        }

        @Override
        public final Builder routeTableId(String routeTableId) {
            this.routeTableId = routeTableId;
            return this;
        }

        public final void setRouteTableId(String routeTableId) {
            this.routeTableId = routeTableId;
        }

        public final Collection<Route.Builder> getRoutes() {
            return this.routes != null ? (Collection)this.routes.stream().map(Route::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder routes(Collection<Route> routes) {
            this.routes = RouteListCopier.copy(routes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routes(Route ... routes) {
            this.routes(Arrays.asList(routes));
            return this;
        }

        public final void setRoutes(Collection<Route.BuilderImpl> routes) {
            this.routes = RouteListCopier.copyFromBuilder(routes);
        }

        public final Collection<Tag.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        public RouteTable build() {
            return new RouteTable(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, RouteTable> {
        public Builder associations(Collection<RouteTableAssociation> var1);

        public Builder associations(RouteTableAssociation ... var1);

        public Builder propagatingVgws(Collection<PropagatingVgw> var1);

        public Builder propagatingVgws(PropagatingVgw ... var1);

        public Builder routeTableId(String var1);

        public Builder routes(Collection<Route> var1);

        public Builder routes(Route ... var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder vpcId(String var1);
    }
}

