/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.ec2.model.CurrencyCodeValues;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ReservedInstanceLimitPrice
implements ToCopyableBuilder<Builder, ReservedInstanceLimitPrice> {
    private final Double amount;
    private final String currencyCode;

    private ReservedInstanceLimitPrice(BuilderImpl builder) {
        this.amount = builder.amount;
        this.currencyCode = builder.currencyCode;
    }

    public Double amount() {
        return this.amount;
    }

    public CurrencyCodeValues currencyCode() {
        return CurrencyCodeValues.fromValue(this.currencyCode);
    }

    public String currencyCodeString() {
        return this.currencyCode;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.amount());
        hashCode = 31 * hashCode + Objects.hashCode(this.currencyCodeString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReservedInstanceLimitPrice)) {
            return false;
        }
        ReservedInstanceLimitPrice other = (ReservedInstanceLimitPrice)obj;
        return Objects.equals(this.amount(), other.amount()) && Objects.equals(this.currencyCodeString(), other.currencyCodeString());
    }

    public String toString() {
        return ToString.builder((String)"ReservedInstanceLimitPrice").add("Amount", (Object)this.amount()).add("CurrencyCode", (Object)this.currencyCodeString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Amount": {
                return Optional.of(clazz.cast(this.amount()));
            }
            case "CurrencyCode": {
                return Optional.of(clazz.cast(this.currencyCodeString()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private Double amount;
        private String currencyCode;

        private BuilderImpl() {
        }

        private BuilderImpl(ReservedInstanceLimitPrice model) {
            this.amount(model.amount);
            this.currencyCode(model.currencyCode);
        }

        public final Double getAmount() {
            return this.amount;
        }

        @Override
        public final Builder amount(Double amount) {
            this.amount = amount;
            return this;
        }

        public final void setAmount(Double amount) {
            this.amount = amount;
        }

        public final String getCurrencyCode() {
            return this.currencyCode;
        }

        @Override
        public final Builder currencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
            return this;
        }

        @Override
        public final Builder currencyCode(CurrencyCodeValues currencyCode) {
            this.currencyCode(currencyCode.toString());
            return this;
        }

        public final void setCurrencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
        }

        public ReservedInstanceLimitPrice build() {
            return new ReservedInstanceLimitPrice(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ReservedInstanceLimitPrice> {
        public Builder amount(Double var1);

        public Builder currencyCode(String var1);

        public Builder currencyCode(CurrencyCodeValues var1);
    }
}

