/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.services.ec2.model.EC2Request;
import software.amazon.awssdk.services.ec2.model.InstanceIdStringListCopier;
import software.amazon.awssdk.services.ec2.model.ReasonCodesListCopier;
import software.amazon.awssdk.services.ec2.model.ReportInstanceReasonCodes;
import software.amazon.awssdk.services.ec2.model.ReportStatusType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ReportInstanceStatusRequest
extends EC2Request
implements ToCopyableBuilder<Builder, ReportInstanceStatusRequest> {
    private final String description;
    private final Instant endTime;
    private final List<String> instances;
    private final List<String> reasonCodes;
    private final Instant startTime;
    private final String status;

    private ReportInstanceStatusRequest(BuilderImpl builder) {
        super(builder);
        this.description = builder.description;
        this.endTime = builder.endTime;
        this.instances = builder.instances;
        this.reasonCodes = builder.reasonCodes;
        this.startTime = builder.startTime;
        this.status = builder.status;
    }

    public String description() {
        return this.description;
    }

    public Instant endTime() {
        return this.endTime;
    }

    public List<String> instances() {
        return this.instances;
    }

    public List<ReportInstanceReasonCodes> reasonCodes() {
        return TypeConverter.convert(this.reasonCodes, ReportInstanceReasonCodes::fromValue);
    }

    public List<String> reasonCodesStrings() {
        return this.reasonCodes;
    }

    public Instant startTime() {
        return this.startTime;
    }

    public ReportStatusType status() {
        return ReportStatusType.fromValue(this.status);
    }

    public String statusString() {
        return this.status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.instances());
        hashCode = 31 * hashCode + Objects.hashCode(this.reasonCodesStrings());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReportInstanceStatusRequest)) {
            return false;
        }
        ReportInstanceStatusRequest other = (ReportInstanceStatusRequest)((Object)obj);
        return Objects.equals(this.description(), other.description()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.instances(), other.instances()) && Objects.equals(this.reasonCodesStrings(), other.reasonCodesStrings()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.statusString(), other.statusString());
    }

    public String toString() {
        return ToString.builder((String)"ReportInstanceStatusRequest").add("Description", (Object)this.description()).add("EndTime", (Object)this.endTime()).add("Instances", this.instances()).add("ReasonCodes", this.reasonCodesStrings()).add("StartTime", (Object)this.startTime()).add("Status", (Object)this.statusString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Description": {
                return Optional.of(clazz.cast(this.description()));
            }
            case "EndTime": {
                return Optional.of(clazz.cast(this.endTime()));
            }
            case "Instances": {
                return Optional.of(clazz.cast(this.instances()));
            }
            case "ReasonCodes": {
                return Optional.of(clazz.cast(this.reasonCodesStrings()));
            }
            case "StartTime": {
                return Optional.of(clazz.cast(this.startTime()));
            }
            case "Status": {
                return Optional.of(clazz.cast(this.statusString()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends EC2Request.BuilderImpl
    implements Builder {
        private String description;
        private Instant endTime;
        private List<String> instances;
        private List<String> reasonCodes;
        private Instant startTime;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(ReportInstanceStatusRequest model) {
            this.description(model.description);
            this.endTime(model.endTime);
            this.instances(model.instances);
            this.reasonCodes(model.reasonCodes);
            this.startTime(model.startTime);
            this.status(model.status);
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        public final Collection<String> getInstances() {
            return this.instances;
        }

        @Override
        public final Builder instances(Collection<String> instances) {
            this.instances = InstanceIdStringListCopier.copy(instances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instances(String ... instances) {
            this.instances(Arrays.asList(instances));
            return this;
        }

        public final void setInstances(Collection<String> instances) {
            this.instances = InstanceIdStringListCopier.copy(instances);
        }

        public final Collection<String> getReasonCodes() {
            return this.reasonCodes;
        }

        @Override
        public final Builder reasonCodes(Collection<String> reasonCodes) {
            this.reasonCodes = ReasonCodesListCopier.copy(reasonCodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reasonCodes(String ... reasonCodes) {
            this.reasonCodes(Arrays.asList(reasonCodes));
            return this;
        }

        public final void setReasonCodes(Collection<String> reasonCodes) {
            this.reasonCodes = ReasonCodesListCopier.copy(reasonCodes);
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ReportStatusType status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public ReportInstanceStatusRequest build() {
            return new ReportInstanceStatusRequest(this);
        }
    }

    public static interface Builder
    extends EC2Request.Builder,
    CopyableBuilder<Builder, ReportInstanceStatusRequest> {
        public Builder description(String var1);

        public Builder endTime(Instant var1);

        public Builder instances(Collection<String> var1);

        public Builder instances(String ... var1);

        public Builder reasonCodes(Collection<String> var1);

        public Builder reasonCodes(String ... var1);

        public Builder startTime(Instant var1);

        public Builder status(String var1);

        public Builder status(ReportStatusType var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

