/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PurchaseRequest
implements ToCopyableBuilder<Builder, PurchaseRequest> {
    private final Integer instanceCount;
    private final String purchaseToken;

    private PurchaseRequest(BuilderImpl builder) {
        this.instanceCount = builder.instanceCount;
        this.purchaseToken = builder.purchaseToken;
    }

    public Integer instanceCount() {
        return this.instanceCount;
    }

    public String purchaseToken() {
        return this.purchaseToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.purchaseToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PurchaseRequest)) {
            return false;
        }
        PurchaseRequest other = (PurchaseRequest)obj;
        return Objects.equals(this.instanceCount(), other.instanceCount()) && Objects.equals(this.purchaseToken(), other.purchaseToken());
    }

    public String toString() {
        return ToString.builder((String)"PurchaseRequest").add("InstanceCount", (Object)this.instanceCount()).add("PurchaseToken", (Object)this.purchaseToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceCount": {
                return Optional.of(clazz.cast(this.instanceCount()));
            }
            case "PurchaseToken": {
                return Optional.of(clazz.cast(this.purchaseToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private Integer instanceCount;
        private String purchaseToken;

        private BuilderImpl() {
        }

        private BuilderImpl(PurchaseRequest model) {
            this.instanceCount(model.instanceCount);
            this.purchaseToken(model.purchaseToken);
        }

        public final Integer getInstanceCount() {
            return this.instanceCount;
        }

        @Override
        public final Builder instanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
            return this;
        }

        public final void setInstanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
        }

        public final String getPurchaseToken() {
            return this.purchaseToken;
        }

        @Override
        public final Builder purchaseToken(String purchaseToken) {
            this.purchaseToken = purchaseToken;
            return this;
        }

        public final void setPurchaseToken(String purchaseToken) {
            this.purchaseToken = purchaseToken;
        }

        public PurchaseRequest build() {
            return new PurchaseRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, PurchaseRequest> {
        public Builder instanceCount(Integer var1);

        public Builder purchaseToken(String var1);
    }
}

