/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.ec2.model.AttachmentStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class InternetGatewayAttachment
implements ToCopyableBuilder<Builder, InternetGatewayAttachment> {
    private final String state;
    private final String vpcId;

    private InternetGatewayAttachment(BuilderImpl builder) {
        this.state = builder.state;
        this.vpcId = builder.vpcId;
    }

    public AttachmentStatus state() {
        return AttachmentStatus.fromValue(this.state);
    }

    public String stateString() {
        return this.state;
    }

    public String vpcId() {
        return this.vpcId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.stateString());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InternetGatewayAttachment)) {
            return false;
        }
        InternetGatewayAttachment other = (InternetGatewayAttachment)obj;
        return Objects.equals(this.stateString(), other.stateString()) && Objects.equals(this.vpcId(), other.vpcId());
    }

    public String toString() {
        return ToString.builder((String)"InternetGatewayAttachment").add("State", (Object)this.stateString()).add("VpcId", (Object)this.vpcId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "State": {
                return Optional.of(clazz.cast(this.stateString()));
            }
            case "VpcId": {
                return Optional.of(clazz.cast(this.vpcId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String state;
        private String vpcId;

        private BuilderImpl() {
        }

        private BuilderImpl(InternetGatewayAttachment model) {
            this.state(model.state);
            this.vpcId(model.vpcId);
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(AttachmentStatus state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        public InternetGatewayAttachment build() {
            return new InternetGatewayAttachment(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, InternetGatewayAttachment> {
        public Builder state(String var1);

        public Builder state(AttachmentStatus var1);

        public Builder vpcId(String var1);
    }
}

