/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.ec2.model.InstanceState;
import software.amazon.awssdk.services.ec2.model.InstanceStatusEvent;
import software.amazon.awssdk.services.ec2.model.InstanceStatusEventListCopier;
import software.amazon.awssdk.services.ec2.model.InstanceStatusSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class InstanceStatus
implements ToCopyableBuilder<Builder, InstanceStatus> {
    private final String availabilityZone;
    private final List<InstanceStatusEvent> events;
    private final String instanceId;
    private final InstanceState instanceState;
    private final InstanceStatusSummary instanceStatus;
    private final InstanceStatusSummary systemStatus;

    private InstanceStatus(BuilderImpl builder) {
        this.availabilityZone = builder.availabilityZone;
        this.events = builder.events;
        this.instanceId = builder.instanceId;
        this.instanceState = builder.instanceState;
        this.instanceStatus = builder.instanceStatus;
        this.systemStatus = builder.systemStatus;
    }

    public String availabilityZone() {
        return this.availabilityZone;
    }

    public List<InstanceStatusEvent> events() {
        return this.events;
    }

    public String instanceId() {
        return this.instanceId;
    }

    public InstanceState instanceState() {
        return this.instanceState;
    }

    public InstanceStatusSummary instanceStatus() {
        return this.instanceStatus;
    }

    public InstanceStatusSummary systemStatus() {
        return this.systemStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.events());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceState());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.systemStatus());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceStatus)) {
            return false;
        }
        InstanceStatus other = (InstanceStatus)obj;
        return Objects.equals(this.availabilityZone(), other.availabilityZone()) && Objects.equals(this.events(), other.events()) && Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.instanceState(), other.instanceState()) && Objects.equals(this.instanceStatus(), other.instanceStatus()) && Objects.equals(this.systemStatus(), other.systemStatus());
    }

    public String toString() {
        return ToString.builder((String)"InstanceStatus").add("AvailabilityZone", (Object)this.availabilityZone()).add("Events", this.events()).add("InstanceId", (Object)this.instanceId()).add("InstanceState", (Object)this.instanceState()).add("InstanceStatus", (Object)this.instanceStatus()).add("SystemStatus", (Object)this.systemStatus()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AvailabilityZone": {
                return Optional.of(clazz.cast(this.availabilityZone()));
            }
            case "Events": {
                return Optional.of(clazz.cast(this.events()));
            }
            case "InstanceId": {
                return Optional.of(clazz.cast(this.instanceId()));
            }
            case "InstanceState": {
                return Optional.of(clazz.cast(this.instanceState()));
            }
            case "InstanceStatus": {
                return Optional.of(clazz.cast(this.instanceStatus()));
            }
            case "SystemStatus": {
                return Optional.of(clazz.cast(this.systemStatus()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String availabilityZone;
        private List<InstanceStatusEvent> events;
        private String instanceId;
        private InstanceState instanceState;
        private InstanceStatusSummary instanceStatus;
        private InstanceStatusSummary systemStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceStatus model) {
            this.availabilityZone(model.availabilityZone);
            this.events(model.events);
            this.instanceId(model.instanceId);
            this.instanceState(model.instanceState);
            this.instanceStatus(model.instanceStatus);
            this.systemStatus(model.systemStatus);
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final Collection<InstanceStatusEvent.Builder> getEvents() {
            return this.events != null ? (Collection)this.events.stream().map(InstanceStatusEvent::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder events(Collection<InstanceStatusEvent> events) {
            this.events = InstanceStatusEventListCopier.copy(events);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder events(InstanceStatusEvent ... events) {
            this.events(Arrays.asList(events));
            return this;
        }

        public final void setEvents(Collection<InstanceStatusEvent.BuilderImpl> events) {
            this.events = InstanceStatusEventListCopier.copyFromBuilder(events);
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final InstanceState.Builder getInstanceState() {
            return this.instanceState != null ? this.instanceState.toBuilder() : null;
        }

        @Override
        public final Builder instanceState(InstanceState instanceState) {
            this.instanceState = instanceState;
            return this;
        }

        public final void setInstanceState(InstanceState.BuilderImpl instanceState) {
            this.instanceState = instanceState != null ? instanceState.build() : null;
        }

        public final InstanceStatusSummary.Builder getInstanceStatus() {
            return this.instanceStatus != null ? this.instanceStatus.toBuilder() : null;
        }

        @Override
        public final Builder instanceStatus(InstanceStatusSummary instanceStatus) {
            this.instanceStatus = instanceStatus;
            return this;
        }

        public final void setInstanceStatus(InstanceStatusSummary.BuilderImpl instanceStatus) {
            this.instanceStatus = instanceStatus != null ? instanceStatus.build() : null;
        }

        public final InstanceStatusSummary.Builder getSystemStatus() {
            return this.systemStatus != null ? this.systemStatus.toBuilder() : null;
        }

        @Override
        public final Builder systemStatus(InstanceStatusSummary systemStatus) {
            this.systemStatus = systemStatus;
            return this;
        }

        public final void setSystemStatus(InstanceStatusSummary.BuilderImpl systemStatus) {
            this.systemStatus = systemStatus != null ? systemStatus.build() : null;
        }

        public InstanceStatus build() {
            return new InstanceStatus(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, InstanceStatus> {
        public Builder availabilityZone(String var1);

        public Builder events(Collection<InstanceStatusEvent> var1);

        public Builder events(InstanceStatusEvent ... var1);

        public Builder instanceId(String var1);

        public Builder instanceState(InstanceState var1);

        default public Builder instanceState(Consumer<InstanceState.Builder> instanceState) {
            return this.instanceState((InstanceState)((InstanceState.Builder)InstanceState.builder().apply(instanceState)).build());
        }

        public Builder instanceStatus(InstanceStatusSummary var1);

        default public Builder instanceStatus(Consumer<InstanceStatusSummary.Builder> instanceStatus) {
            return this.instanceStatus((InstanceStatusSummary)((InstanceStatusSummary.Builder)InstanceStatusSummary.builder().apply(instanceStatus)).build());
        }

        public Builder systemStatus(InstanceStatusSummary var1);

        default public Builder systemStatus(Consumer<InstanceStatusSummary.Builder> systemStatus) {
            return this.systemStatus((InstanceStatusSummary)((InstanceStatusSummary.Builder)InstanceStatusSummary.builder().apply(systemStatus)).build());
        }
    }
}

