/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class InstanceCapacity
implements ToCopyableBuilder<Builder, InstanceCapacity> {
    private final Integer availableCapacity;
    private final String instanceType;
    private final Integer totalCapacity;

    private InstanceCapacity(BuilderImpl builder) {
        this.availableCapacity = builder.availableCapacity;
        this.instanceType = builder.instanceType;
        this.totalCapacity = builder.totalCapacity;
    }

    public Integer availableCapacity() {
        return this.availableCapacity;
    }

    public String instanceType() {
        return this.instanceType;
    }

    public Integer totalCapacity() {
        return this.totalCapacity;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.availableCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalCapacity());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceCapacity)) {
            return false;
        }
        InstanceCapacity other = (InstanceCapacity)obj;
        return Objects.equals(this.availableCapacity(), other.availableCapacity()) && Objects.equals(this.instanceType(), other.instanceType()) && Objects.equals(this.totalCapacity(), other.totalCapacity());
    }

    public String toString() {
        return ToString.builder((String)"InstanceCapacity").add("AvailableCapacity", (Object)this.availableCapacity()).add("InstanceType", (Object)this.instanceType()).add("TotalCapacity", (Object)this.totalCapacity()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AvailableCapacity": {
                return Optional.of(clazz.cast(this.availableCapacity()));
            }
            case "InstanceType": {
                return Optional.of(clazz.cast(this.instanceType()));
            }
            case "TotalCapacity": {
                return Optional.of(clazz.cast(this.totalCapacity()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private Integer availableCapacity;
        private String instanceType;
        private Integer totalCapacity;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceCapacity model) {
            this.availableCapacity(model.availableCapacity);
            this.instanceType(model.instanceType);
            this.totalCapacity(model.totalCapacity);
        }

        public final Integer getAvailableCapacity() {
            return this.availableCapacity;
        }

        @Override
        public final Builder availableCapacity(Integer availableCapacity) {
            this.availableCapacity = availableCapacity;
            return this;
        }

        public final void setAvailableCapacity(Integer availableCapacity) {
            this.availableCapacity = availableCapacity;
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final Integer getTotalCapacity() {
            return this.totalCapacity;
        }

        @Override
        public final Builder totalCapacity(Integer totalCapacity) {
            this.totalCapacity = totalCapacity;
            return this;
        }

        public final void setTotalCapacity(Integer totalCapacity) {
            this.totalCapacity = totalCapacity;
        }

        public InstanceCapacity build() {
            return new InstanceCapacity(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, InstanceCapacity> {
        public Builder availableCapacity(Integer var1);

        public Builder instanceType(String var1);

        public Builder totalCapacity(Integer var1);
    }
}

